/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.ingame;

import dev.tauri.jsg.config.ingame.BlockConfigOptionRegistry;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class JSGTileEntityConfig {
    @Nonnull
    private List<JSGConfigOption<?>> options;
    private ResourceLocation blockType = new ResourceLocation("unknown");

    public JSGTileEntityConfig(@Nonnull ResourceLocation blockType) {
        this();
        this.blockType = blockType;
        this.reset();
    }

    public JSGTileEntityConfig(@Nonnull ByteBuf buf) {
        this();
        this.reset();
        this.fromBytes(buf);
    }

    public JSGTileEntityConfig() {
        this.options = new ArrayList();
    }

    public void addOption(@Nonnull JSGConfigOption<?> option) {
        this.options.add(option);
    }

    protected void reset() {
        this.options.clear();
        this.options.addAll(BlockConfigOptionRegistry.get(this.blockType));
    }

    public List<JSGConfigOption<?>> getOptions() {
        return this.options;
    }

    public boolean has(String string) {
        return this.options.parallelStream().anyMatch(opt -> opt.getLabel().equals(string));
    }

    @Nonnull
    public JSGConfigOption<?> getOption(int id) {
        return this.options.get(id);
    }

    @Nonnull
    public JSGConfigOption<?> getOption(String label) {
        return this.getOptionMaybe(label).orElseThrow(() -> new NoSuchElementException("No such config option with label: \"%s\"".formatted(label)));
    }

    @Nonnull
    public Optional<JSGConfigOption<?>> getOptionMaybe(String label) {
        return this.options.stream().filter(o -> o.getLabel().equals(label)).findFirst();
    }

    public void clearOptions() {
        this.options.clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.options.stream().filter(o -> Optional.ofNullable(o.getValue()).map(o.defaultValue::equals).orElse(o.defaultValue != null) == false).forEach(o -> compound.m_128365_(o.label, o.valueAsNBT()));
        return compound;
    }

    public boolean deserializeNBT(CompoundTag compound) {
        return ((Stream)this.options.stream().map(o -> Optional.ofNullable(compound.m_128423_(o.label)).map(o::setValue).orElse(false)).parallel()).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockType.toString().length());
        buf.writeCharSequence((CharSequence)this.blockType.toString(), StandardCharsets.UTF_8);
        this.options.stream().forEach(o -> o.writeBytes(buf));
    }

    public void fromBytes(ByteBuf buf) {
        this.blockType = new ResourceLocation(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString());
        this.options.clear();
        this.options.addAll(BlockConfigOptionRegistry.get(this.blockType));
        this.options.stream().forEach(o -> o.readBytes(buf));
    }
}

