/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.util;

import dev.tauri.jsg.block.dialhomedevice.DHDAbstractBlock;
import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.block.stargate.StargateAbstractMemberBlock;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.parsers.BiomeParser;
import dev.tauri.jsg.config.parsers.BlockMetaParser;
import dev.tauri.jsg.config.parsers.ItemMetaParser;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.TagsRegistry;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public class JSGConfigUtil {
    private static Map<BlockState, Boolean> cachedCamoBlacklistBlocks = null;
    private static List<Block> camoBlocksBlacklistParsed = null;
    private static Map<Biome, BiomeOverlayEnum> cachedBiomeMatchesReverse = null;
    private static Map<BiomeOverlayEnum, List<Block>> cachedBiomeOverrideBlocks = null;
    private static Map<Block, BiomeOverlayEnum> cachedBiomeOverrideBlocksReverse = null;

    public static void reloadConfig() {
        JSGConfigUtil.resetCache();
    }

    public static void resetCache() {
        cachedCamoBlacklistBlocks = null;
        cachedBiomeMatchesReverse = null;
        cachedBiomeOverrideBlocks = null;
        cachedBiomeOverrideBlocksReverse = null;
    }

    public static boolean canKawooshDestroyBlock(BlockState state) {
        if (state.m_60734_() == BlockRegistry.IRIS_BLOCK.get()) {
            return false;
        }
        if (state.m_60734_() == BlockRegistry.INVISIBLE_BLOCK.get()) {
            return false;
        }
        if (state.m_60734_() instanceof StargateAbstractBaseBlock) {
            return false;
        }
        if (state.m_60734_() instanceof StargateAbstractMemberBlock) {
            return false;
        }
        return !state.m_204336_(TagsRegistry.KAWOOSH_INVINCIBLE);
    }

    public static boolean canBeUsedAsCamoBlock(BlockState state) {
        if (camoBlocksBlacklistParsed == null) {
            camoBlocksBlacklistParsed = new ArrayList<Block>();
            for (RegistryObject<?> object : BlockRegistry.CAMO_BLOCKS_BLACKLIST) {
                camoBlocksBlacklistParsed.add((Block)object.get());
            }
        }
        if (BlockRegistry.isInBlocksArray(state.m_60734_(), camoBlocksBlacklistParsed.toArray(new Block[0]))) {
            return false;
        }
        if (state.m_60734_() instanceof StargateAbstractBaseBlock) {
            return false;
        }
        if (state.m_60734_() instanceof StargateAbstractMemberBlock) {
            return false;
        }
        if (state.m_60734_() instanceof DHDAbstractBlock) {
            return false;
        }
        if (cachedCamoBlacklistBlocks == null) {
            cachedCamoBlacklistBlocks = BlockMetaParser.parseConfig((List)JSGConfig.Stargate.camoBlacklist.get());
        }
        if (cachedCamoBlacklistBlocks.get(state.m_60734_().m_49966_()) != null && cachedCamoBlacklistBlocks.get(state.m_60734_().m_49966_()).booleanValue()) {
            return false;
        }
        return cachedCamoBlacklistBlocks.get(state) == null;
    }

    public static Map<Biome, BiomeOverlayEnum> getBiomeOverrideBiomes() {
        if (cachedBiomeMatchesReverse == null) {
            cachedBiomeMatchesReverse = new HashMap<Biome, BiomeOverlayEnum>();
            for (Map.Entry<BiomeOverlayEnum, ForgeConfigSpec.ConfigValue<List<? extends String>>> entry : JSGConfig.Stargate.biomeMatches.entrySet()) {
                List<Biome> parsedList = BiomeParser.parseConfig((List)entry.getValue().get());
                BiomeOverlayEnum biomeOverlay = entry.getKey();
                for (Biome biome : parsedList) {
                    cachedBiomeMatchesReverse.put(biome, biomeOverlay);
                }
            }
        }
        return cachedBiomeMatchesReverse;
    }

    private static void genBiomeOverrideCache() {
        cachedBiomeOverrideBlocks = new HashMap<BiomeOverlayEnum, List<Block>>();
        cachedBiomeOverrideBlocksReverse = new HashMap<Block, BiomeOverlayEnum>();
        for (BiomeOverlayEnum e : BiomeOverlayEnum.values()) {
            cachedBiomeOverrideBlocks.put(e, new ArrayList());
        }
        for (Map.Entry entry : JSGConfig.Stargate.biomeOverrideBlocks.entrySet()) {
            List<Block> parsedList = ItemMetaParser.parseConfig((List)((ForgeConfigSpec.ConfigValue)entry.getValue()).get());
            BiomeOverlayEnum biomeOverlay = (BiomeOverlayEnum)entry.getKey();
            cachedBiomeOverrideBlocks.put(biomeOverlay, parsedList);
            for (Block stack : parsedList) {
                cachedBiomeOverrideBlocksReverse.put(stack, biomeOverlay);
            }
        }
    }

    public static Map<BiomeOverlayEnum, List<Block>> getBiomeOverrideBlocks() {
        if (cachedBiomeOverrideBlocks == null) {
            JSGConfigUtil.genBiomeOverrideCache();
        }
        if (cachedBiomeOverrideBlocks == null) {
            return new HashMap<BiomeOverlayEnum, List<Block>>();
        }
        return cachedBiomeOverrideBlocks;
    }

    public static Map<Block, BiomeOverlayEnum> getBiomeOverrideItemMetaPairs() {
        if (cachedBiomeOverrideBlocksReverse == null) {
            JSGConfigUtil.genBiomeOverrideCache();
        }
        return cachedBiomeOverrideBlocksReverse;
    }
}

