/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.effect;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.helpers.JSGMinecraftHelper;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.sound.JSGSoundHelperClient;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class StargateWormholeEffect {
    public static long playingStarted = -1L;
    public static boolean isPlaying = false;
    public static float lastSpeed = -1.0f;
    public static boolean isFlying = false;
    public static StargateWormholeType type = StargateWormholeType.MILKYWAY;
    public static int length;
    private static BlockPos travelSoundPos;

    public static void play(StargateWormholeType type, int length) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        StargateWormholeEffect.type = type;
        StargateWormholeEffect.length = length;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        isFlying = p.m_150110_().f_35935_;
        lastSpeed = p.m_150110_().m_35942_();
        p.m_150110_().m_35943_(0.0f);
        playingStarted = JSGMinecraftHelper.getPlayerTickClientSide();
        Vec3 v = p.m_20182_();
        travelSoundPos = new BlockPos((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_);
        JSGSoundHelperClient.playPositionedSoundClientSide(travelSoundPos, SoundPositionedEnum.WORMHOLE_TRAVEL, true);
        isPlaying = true;
    }

    public static void stop() {
        playingStarted = -1L;
        isPlaying = false;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (lastSpeed > -1.0f) {
            p.m_150110_().m_35943_(lastSpeed);
        }
        p.m_150110_().f_35935_ = isFlying;
        p.m_6885_();
        Vec3 v = p.m_20182_();
        JSGSoundHelperClient.playPositionedSoundClientSide(travelSoundPos, SoundPositionedEnum.WORMHOLE_TRAVEL, false);
        JSGSoundHelperClient.playSoundEventClientSide(new BlockPos((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_), SoundEventEnum.WORMHOLE_GO, 1.0f, 1.0f);
    }

    public static int getCurrentAnimationState() {
        if (playingStarted == -1L) {
            return 0;
        }
        long tick = JSGMinecraftHelper.getPlayerTickClientSide() - playingStarted;
        int frame = (int)(JSGMinecraftHelper.getPlayerTickClientSide() - playingStarted) % (StargateWormholeEffect.type.endFrame - StargateWormholeEffect.type.startFrame) + StargateWormholeEffect.type.startFrame;
        if (tick > (long)length * 20L) {
            StargateWormholeEffect.stop();
        }
        if (frame < StargateWormholeEffect.type.startFrame) {
            return StargateWormholeEffect.type.startFrame;
        }
        return Math.min(frame, StargateWormholeEffect.type.endFrame);
    }

    @SubscribeEvent
    public static void onMouseWheel(InputEvent.MouseScrollingEvent event) {
        if (isPlaying) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (isPlaying) {
            InputConstants.Key key = InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode());
            KeyMapping.m_90837_((InputConstants.Key)key, (boolean)false);
        }
    }

    public static void render(ForgeGui forgeGui, GuiGraphics graphics, float partialTicks, int packedLight, int packedOverlay) {
        if (!isPlaying) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        Object introFrame = "";
        int introFrameInt = StargateWormholeEffect.getCurrentAnimationState();
        introFrame = introFrameInt < 10 ? "00" + introFrameInt : (introFrameInt < 100 ? "0" + introFrameInt : "" + introFrameInt);
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/wormhole/" + type.name().toLowerCase() + "/ezgif-frame-" + (String)introFrame + ".jpg"));
        GuiHelper.currentStack = graphics.m_280168_();
        GuiHelper.drawScaledCustomSizeModalRect(0, 0, 0.0f, 0.0f, 1920, 1080, graphics.m_280182_(), graphics.m_280206_(), 1920.0f, 1080.0f);
        stack.m_85849_();
    }

    static {
        travelSoundPos = null;
    }
}

