/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.effect;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.effect.StargateWormholeEffectToClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
public class StargateWormholeHandler {
    public static final Map<UUID, Long> WORMHOLE_ANIMATION_END_MAP = new HashMap<UUID, Long>();
    public static final Map<UUID, GameType> PLAYER_GAMEMODE_BACKUP = new HashMap<UUID, GameType>();
    public static final Map<UUID, Float> PLAYER_SPEED_BACKUP = new HashMap<UUID, Float>();
    public static final Map<UUID, PlaceEntityInterface> PLAYER_PLACER_INTERFACES = new HashMap<UUID, PlaceEntityInterface>();

    public static void handle(ServerPlayer sp, PlaceEntityInterface placer, StargateWormholeType type, int length) {
        long time = System.currentTimeMillis();
        WORMHOLE_ANIMATION_END_MAP.put(sp.m_20148_(), time + (long)length * 1000L);
        JSGPacketHandler.sendTo(new StargateWormholeEffectToClient(false, type, length), sp);
        PLAYER_SPEED_BACKUP.put(sp.m_20148_(), Float.valueOf(sp.m_6113_()));
        sp.m_7910_(0.0f);
        PLAYER_GAMEMODE_BACKUP.put(sp.m_20148_(), sp.f_8941_.m_9290_());
        sp.m_143403_(GameType.SPECTATOR);
        PLAYER_PLACER_INTERFACES.put(sp.m_20148_(), placer);
    }

    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        ArrayList<UUID> toDelete = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> t : WORMHOLE_ANIMATION_END_MAP.entrySet()) {
            if (System.currentTimeMillis() < t.getValue()) continue;
            toDelete.add(t.getKey());
        }
        for (UUID k : toDelete) {
            StargateWormholeHandler.release(k);
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        StargateWormholeHandler.release(sp);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        StargateWormholeHandler.release(sp);
    }

    public static void release(@Nonnull ServerPlayer sp) {
        StargateWormholeHandler.release(sp.m_20148_());
    }

    public static void release(UUID uuid) {
        if (!WORMHOLE_ANIMATION_END_MAP.containsKey(uuid)) {
            return;
        }
        WORMHOLE_ANIMATION_END_MAP.remove(uuid);
        ServerPlayer sp = JSG.currentServer.m_6846_().m_11259_(uuid);
        if (sp == null) {
            return;
        }
        JSGPacketHandler.sendTo(new StargateWormholeEffectToClient(true, StargateWormholeType.MILKYWAY, 0), sp);
        sp.m_7910_(PLAYER_SPEED_BACKUP.get(uuid).floatValue());
        sp.m_143403_(PLAYER_GAMEMODE_BACKUP.get(uuid));
        PLAYER_PLACER_INTERFACES.get(uuid).place();
    }

    public static interface PlaceEntityInterface {
        public void place();
    }
}

