/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tauri.jsg.entity.animal.MastadgeEntity;
import dev.tauri.jsg.entity.animations.MastadgeAnimations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class MastadgeModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart mastadge;
    private final ModelPart legs;
    private final ModelPart front_legs;
    private final ModelPart right_leg_f;
    private final ModelPart left_leg_f;
    private final ModelPart back_legs;
    private final ModelPart left_leg_b;
    private final ModelPart right_leg_b;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart hitbox;
    private final List<ModelPart> saddleParts = new ArrayList<ModelPart>();
    private final List<ModelPart> ridingParts = new ArrayList<ModelPart>();

    public MastadgeModel(ModelPart root) {
        this.mastadge = root.m_171324_("model");
        this.legs = this.mastadge.m_171324_("legs");
        this.front_legs = this.legs.m_171324_("front_legs");
        this.right_leg_f = this.front_legs.m_171324_("right_leg_f");
        this.left_leg_f = this.front_legs.m_171324_("left_leg_f");
        this.back_legs = this.legs.m_171324_("back_legs");
        this.left_leg_b = this.back_legs.m_171324_("left_leg_b");
        this.right_leg_b = this.back_legs.m_171324_("right_leg_b");
        this.body = this.mastadge.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.neck = this.mastadge.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.hitbox = root.m_171324_("hitbox");
        this.saddleParts.add(this.body.m_171324_("mount_r1"));
        this.ridingParts.add(this.head.m_171324_("acces_r1"));
        this.ridingParts.add(this.head.m_171324_("acces_r2"));
        this.ridingParts.add(this.head.m_171324_("acces_r3"));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition model = partdefinition.m_171599_("model", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)15.0f));
        PartDefinition legs = model.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0667f, (float)-3.9687f));
        PartDefinition front_legs = legs.m_171599_("front_legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-13.5f));
        front_legs.m_171599_("right_leg_f", CubeListBuilder.m_171558_().m_171514_(36, 95).m_171488_(-3.5f, -4.0f, -4.5f, 7.0f, 38.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 197).m_171488_(-3.5f, -4.7f, -4.5f, 7.0f, 35.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)13.5f, (float)-1.0f, (float)0.0f));
        front_legs.m_171599_("left_leg_f", CubeListBuilder.m_171558_().m_171514_(0, 197).m_171480_().m_171488_(-3.5f, -4.7f, -4.5f, 7.0f, 36.0f, 9.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(1, 95).m_171488_(-3.5f, -4.0f, -4.5f, 7.0f, 38.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.5f, (float)-1.0f, (float)0.0f));
        PartDefinition back_legs = legs.m_171599_("back_legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)16.5f));
        back_legs.m_171599_("left_leg_b", CubeListBuilder.m_171558_().m_171514_(33, 198).m_171480_().m_171488_(-3.5f, -2.2f, -4.0f, 7.0f, 24.0f, 8.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(135, 1).m_171488_(-3.5f, -2.0f, -4.0f, 7.0f, 26.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-12.5f, (float)-1.0f, (float)-0.5f));
        back_legs.m_171599_("right_leg_b", CubeListBuilder.m_171558_().m_171514_(62, 137).m_171488_(-3.5f, -2.0f, -4.0f, 7.0f, 26.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(33, 198).m_171488_(-3.5f, -2.2f, -4.0f, 7.0f, 24.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)12.5f, (float)-1.0f, (float)-0.5f));
        PartDefinition body = model.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-11.5f, -14.7594f, -25.4511f, 23.0f, 22.0f, 27.0f, new CubeDeformation(0.0f)).m_171514_(171, 64).m_171488_(-11.5f, 3.9406f, -25.4511f, 23.0f, 0.0f, 27.0f, new CubeDeformation(0.0f)).m_171514_(172, 0).m_171480_().m_171488_(-9.0f, 3.2813f, -23.1854f, 18.0f, 6.0f, 24.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(85, 206).m_171488_(-5.05f, 3.4319f, -22.1379f, 10.0f, 9.0f, 16.4f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.974f, (float)-0.703f));
        body.m_171599_("mount_r1", CubeListBuilder.m_171558_().m_171514_(186, 228).m_171488_(-9.15f, -6.0f, -7.7f, 18.3f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-16.9524f, (float)-20.5479f, (float)0.3927f, (float)0.0f, (float)0.0f));
        body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(192, 33).m_171480_().m_171488_(-8.5f, -2.5f, -6.3f, 16.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)8.2813f, (float)7.8146f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(85, 33).m_171488_(-8.0f, -16.5f, -11.5f, 16.0f, 20.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.8694f, (float)-14.9116f, (float)0.3927f, (float)0.0f, (float)0.0f));
        body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(73, 73).m_171488_(-9.0f, -7.5f, -9.0f, 18.0f, 16.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-14.2594f, (float)-13.4511f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        body.m_171599_("low2_r1", CubeListBuilder.m_171558_().m_171514_(175, 91).m_171488_(-10.5f, 10.0f, -13.0f, 21.0f, 0.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-10.5f, -7.0f, -12.9f, 21.0f, 20.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.3111f, (float)9.8847f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.0f, -0.5f, 5.0f, 18.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.3111f, (float)22.3847f));
        PartDefinition neck = model.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(106, 168).m_171488_(-4.65f, -6.95f, -14.2f, 10.0f, 14.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 143).m_171488_(-5.0f, 6.626f, -11.6919f, 10.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.6015f, (float)-22.59f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(134, 36).m_171488_(-4.6f, 2.4361f, -12.774f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.3f)).m_171514_(70, 111).m_171488_(-7.0f, -9.4139f, -12.224f, 14.0f, 13.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(156, 85).m_171488_(7.1f, -11.0139f, -12.224f, 0.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(156, 85).m_171480_().m_171488_(-7.1f, -11.0139f, -12.224f, 0.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)1.79f, (float)-9.2179f));
        head.m_171599_("acces_r1", CubeListBuilder.m_171558_().m_171514_(34, 172).m_171488_(-6.95f, -7.35f, -1.0f, 14.0f, 14.0f, 2.0f, new CubeDeformation(0.4f)), PartPose.m_171423_((float)-0.05f, (float)-1.9381f, (float)-10.9249f, (float)0.5236f, (float)0.0f, (float)0.0f));
        head.m_171599_("acces_r2", CubeListBuilder.m_171558_().m_171514_(151, 62).m_171488_(-9.5f, 2.3f, -3.6f, 18.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)3.5828f, (float)-3.1083f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        head.m_171599_("acces_r3", CubeListBuilder.m_171558_().m_171514_(167, 131).m_171480_().m_171488_(-1.7f, -7.7f, -5.2f, 17.0f, 12.0f, 22.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.8f, (float)-2.4172f, (float)-5.1083f, (float)0.7854f, (float)0.0f, (float)0.0f));
        head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(110, 0).m_171488_(-5.6f, -2.35f, -3.0f, 10.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)5.4361f, (float)-14.774f, (float)0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(121, 111).m_171488_(-3.6f, -7.0f, -4.2f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.4f, (float)0.0787f, (float)-16.7418f, (float)0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171488_(-5.0f, 1.1f, -14.4f, 10.0f, 9.0f, 16.0f, new CubeDeformation(0.1f)).m_171514_(150, 49).m_171488_(-5.5f, -1.05f, -14.45f, 11.0f, 2.0f, 6.0f, new CubeDeformation(0.25f)).m_171514_(140, 136).m_171488_(-6.0f, -1.45f, -8.55f, 12.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(132, 70).m_171488_(-4.5f, -3.6f, -13.2f, 9.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0361f, (float)-3.474f));
        partdefinition.m_171599_("hitbox", CubeListBuilder.m_171558_().m_171514_(62, 145).m_171488_(-16.0f, -6.0f, -32.5f, 32.0f, 46.0f, 65.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    @ParametersAreNonnullByDefault
    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        MastadgeEntity pEntity = (MastadgeEntity)((Object)entity);
        boolean isSaddled = pEntity.m_6254_();
        boolean isRidden = pEntity.m_20160_();
        for (ModelPart s : this.saddleParts) {
            s.f_104207_ = isSaddled;
        }
        for (ModelPart r : this.ridingParts) {
            r.f_104207_ = isRidden && isSaddled;
        }
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(MastadgeAnimations.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(pEntity.f_252486_, MastadgeAnimations.SIT, ageInTicks, 1.0f);
        this.m_233385_(pEntity.f_244242_, MastadgeAnimations.SIT_UP, ageInTicks, 1.0f);
        this.m_233385_(pEntity.f_244047_, MastadgeAnimations.IDLE, ageInTicks, 1.0f);
        this.m_233385_(pEntity.f_244243_, MastadgeAnimations.EAT, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    @ParametersAreNonnullByDefault
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.mastadge.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.mastadge;
    }
}

