/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.block.JSGOreBlock;
import dev.tauri.jsg.block.JSGTabbedBlock;
import dev.tauri.jsg.block.JSGTabbedFallingBlock;
import dev.tauri.jsg.block.crystal.CrystalBudBlock;
import dev.tauri.jsg.block.crystal.CrystalBudType;
import dev.tauri.jsg.block.crystal.CrystalBuddingBlock;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.registry.BiomeRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockHelpers {
    public static RegistryObject<Block> createGenericBlockWithGenericTooltip(String name, final RegistryObject<CreativeModeTab> tab, BlockBehaviour.Properties prop) {
        return BlockRegistry.REGISTER.register(name, () -> new JSGTabbedBlock(prop){

            @Override
            public RegistryObject<CreativeModeTab> getTab() {
                return tab;
            }

            @ParametersAreNonnullByDefault
            public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
                ItemHelper.applyGenericToolTip(this.m_7705_(), components, tooltipFlag);
            }
        });
    }

    public static RegistryObject<Block> createGenericBlock(String name, final RegistryObject<CreativeModeTab> tab, BlockBehaviour.Properties prop) {
        return BlockRegistry.REGISTER.register(name, () -> new JSGTabbedBlock(prop){

            @Override
            public RegistryObject<CreativeModeTab> getTab() {
                return tab;
            }
        });
    }

    public static RegistryObject<Block> createGenericOreBlock(String name, final RegistryObject<CreativeModeTab> tab, BlockBehaviour.Properties prop) {
        return BlockRegistry.REGISTER.register(name, () -> new JSGOreBlock(prop){

            @Override
            public RegistryObject<CreativeModeTab> getTab() {
                return tab;
            }
        });
    }

    public static RegistryObject<Block> createGenericFallingOreBlock(String name, final RegistryObject<CreativeModeTab> tab, BlockBehaviour.Properties prop) {
        return BlockRegistry.REGISTER.register(name, () -> new JSGTabbedFallingBlock(prop){

            @Override
            public RegistryObject<CreativeModeTab> getTab() {
                return tab;
            }
        });
    }

    public static Map<OreBlockVariant, RegistryObject<Block>> createOreBlock(String name) {
        HashMap<OreBlockVariant, RegistryObject<Block>> result = new HashMap<OreBlockVariant, RegistryObject<Block>>();
        for (OreBlockVariant type : OreBlockVariant.values()) {
            if (type == OreBlockVariant.SELF) continue;
            String nameFinal = (String)(type.prefix != null ? type.prefix + "_" : "") + name;
            RegistryObject<Block> block = BlockHelpers.createGenericOreBlock(nameFinal, TabRegistry.TAB_RESOURCES, BlockBehaviour.Properties.m_284310_());
            result.put(type, block);
        }
        return result;
    }

    public static Map<CrystalColor, RegistryObject<Block>> createCrystalBlock(String name, BlockBehaviour.Properties props) {
        HashMap<CrystalColor, RegistryObject<Block>> result = new HashMap<CrystalColor, RegistryObject<Block>>();
        for (CrystalColor color : CrystalColor.values()) {
            String nameFinal = name.replaceAll("\\{color}", color.name().toLowerCase());
            RegistryObject<Block> block = BlockHelpers.createGenericBlock(nameFinal, TabRegistry.TAB_RESOURCES, props);
            result.put(color, block);
        }
        return result;
    }

    public static Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> createCrystalBuddingBlock(String name) {
        HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> result = new HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>>();
        for (OreBlockVariant type : OreBlockVariant.values()) {
            HashMap<CrystalColor, RegistryObject> result2 = new HashMap<CrystalColor, RegistryObject>();
            for (CrystalColor color : CrystalColor.values()) {
                String nameFinal = (String)(type.prefix != null ? type.prefix + "_" : "") + name.replaceAll("\\{color}", color.name().toLowerCase());
                RegistryObject block = BlockRegistry.REGISTER.register(nameFinal, () -> new CrystalBuddingBlock(color));
                result2.put(color, block);
            }
            result.put(type, result2);
        }
        return result;
    }

    public static Map<CrystalColor, RegistryObject<Block>> createCrystalBudBlock(String name, CrystalBudType budType) {
        HashMap<CrystalColor, RegistryObject<Block>> result = new HashMap<CrystalColor, RegistryObject<Block>>();
        for (CrystalColor color : CrystalColor.values()) {
            String nameFinal = name.replaceAll("\\{color}", color.name().toLowerCase());
            RegistryObject block = BlockRegistry.REGISTER.register(nameFinal, () -> new CrystalBudBlock(budType, color));
            result.put(color, (RegistryObject<Block>)block);
        }
        return result;
    }

    public static boolean isBlockDirectlyUnderSky(Level world, BlockPos pos) {
        int blocksCount = 0;
        int maxBlocks = 3;
        while (pos.m_123342_() < 255) {
            pos = pos.m_7494_();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(world.m_8055_(pos).m_60795_() || block instanceof LeavesBlock || state.m_247087_())) {
                ++blocksCount;
            }
            if (blocksCount <= maxBlocks) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getHighest(List<BlockPos> list) {
        int maxy = Integer.MIN_VALUE;
        BlockPos top = null;
        for (BlockPos pos : list) {
            if (pos.m_123342_() <= maxy) continue;
            maxy = pos.m_123342_();
            top = pos.m_7949_();
        }
        return top;
    }

    public static BlockPos getHighestWithXZCords(List<BlockPos> list, int x, int z) {
        int maxy = Integer.MIN_VALUE;
        BlockPos top = null;
        for (BlockPos pos : list) {
            if (pos.m_123342_() <= maxy || !(pos.m_123341_() == x & pos.m_123343_() == z)) continue;
            maxy = pos.m_123342_();
            top = pos.m_7949_();
        }
        return top;
    }

    public static String blockPosToBetterString(BlockPos pos) {
        if (pos == null) {
            return "null";
        }
        return pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
    }

    public static boolean isInBlocksArray(Block block, Block[] array) {
        for (Block b : array) {
            if (block != b) continue;
            return true;
        }
        return false;
    }

    public static enum OreBlockVariant {
        SAND("sand", Biomes.f_48203_, Biomes.f_48159_, BiomeRegistry.ABYDOS),
        NETHER("netherrack", Biomes.f_48209_),
        DEEPSLATE("deepslate", new ResourceKey[0]),
        END("endstone", Biomes.f_48210_, Biomes.f_48165_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_),
        STONE(null, new ResourceKey[0]),
        SELF("self", new ResourceKey[0]);

        public final String prefix;
        public final List<ResourceKey<Biome>> supportedBiomes;

        @SafeVarargs
        private OreBlockVariant(String prefix, ResourceKey<Biome> ... supportedBiomes) {
            this.prefix = prefix;
            this.supportedBiomes = List.of(supportedBiomes);
        }
    }
}

