/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class BlockPosHelper {
    @Nonnull
    public static BlockPos rotate(@Nonnull BlockPos pos, @Nonnull Direction horizontal, @Nullable Direction vertical) {
        return BlockPosHelper.rotate(pos, horizontal, vertical, false);
    }

    public static BlockPos rotate(@Nonnull BlockPos pos, @Nonnull Direction horizontal, @Nullable Direction vertical, boolean flip) {
        if (flip) {
            return BlockPosHelper.rotateVertical(BlockPosHelper.rotateHorizontal(pos, horizontal), vertical);
        }
        return BlockPosHelper.rotateHorizontal(BlockPosHelper.rotateVertical(pos, vertical), horizontal);
    }

    private static BlockPos rotateHorizontal(BlockPos pos, Direction dir) {
        return pos.m_7954_(BlockPosHelper.getRotation(dir));
    }

    public static float asYaw(float rotationDegrees) {
        double sin = Math.sin(Math.toRadians(rotationDegrees));
        double cos = Math.cos(Math.toRadians(rotationDegrees));
        return (float)Math.toDegrees(sin > 0.0 ? Math.acos(cos) : -Math.acos(cos));
    }

    public static Rotation rotate180(Rotation r) {
        return BlockPosHelper.rotate180(r, true);
    }

    public static Direction rotate180(Direction r) {
        if (r == null) {
            return null;
        }
        return r.m_122424_();
    }

    public static Rotation rotate180(Rotation r, boolean rotateNone) {
        return switch (r) {
            case Rotation.CLOCKWISE_90 -> Rotation.COUNTERCLOCKWISE_90;
            case Rotation.CLOCKWISE_180 -> Rotation.NONE;
            case Rotation.COUNTERCLOCKWISE_90 -> Rotation.CLOCKWISE_90;
            default -> rotateNone ? Rotation.CLOCKWISE_180 : Rotation.NONE;
        };
    }

    public static BlockPos rotateVertical(BlockPos pos, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_90) {
            int z = -pos.m_123342_();
            int y = pos.m_123343_();
            int x = pos.m_123341_();
            return new BlockPos(x, y, z);
        }
        if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            int z = pos.m_123342_();
            int y = -pos.m_123343_();
            int x = pos.m_123341_();
            return new BlockPos(x, y, z);
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return BlockPosHelper.rotateVertical(BlockPosHelper.rotateVertical(pos, Rotation.CLOCKWISE_90), Rotation.CLOCKWISE_90);
        }
        return pos;
    }

    public static Vec3 rotateHorizontal(Vec3 pos, Rotation rotation) {
        Vec3 v = switch (rotation) {
            default -> pos;
            case Rotation.CLOCKWISE_90 -> new Vec3(-pos.m_7094_(), pos.m_7098_(), pos.m_7096_());
            case Rotation.CLOCKWISE_180 -> new Vec3(-pos.m_7096_(), pos.m_7098_(), -pos.m_7094_());
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3(pos.m_7094_(), pos.m_7098_(), -pos.m_7096_());
        };
        return v;
    }

    public static Vec3 rotate(Vec3 pos, Direction horizontal, Direction vertical) {
        return BlockPosHelper.rotate(pos, BlockPosHelper.getRotation(horizontal), BlockPosHelper.getRotation(vertical), Direction.SOUTH.m_122434_());
    }

    public static Vec3 rotate(Vec3 pos, Rotation horizontal, Rotation vertical, Direction.Axis axis) {
        return BlockPosHelper.rotate(pos, horizontal, vertical, axis, false);
    }

    public static Vec3 rotate(Vec3 pos, Rotation horizontal, Rotation vertical, Direction.Axis axis, boolean flip) {
        if (flip) {
            return BlockPosHelper.rotateVertical(BlockPosHelper.rotateHorizontal(pos, horizontal), vertical, axis);
        }
        return BlockPosHelper.rotateHorizontal(BlockPosHelper.rotateVertical(pos, vertical, axis), horizontal);
    }

    public static Vec3 rotateVertical(Vec3 pos, Rotation rotation, Direction.Axis axis) {
        Vec3 v = pos;
        if (axis != Direction.Axis.Z) {
            if (rotation == Rotation.CLOCKWISE_90) {
                double z = -pos.m_7098_();
                double y = pos.m_7094_();
                double x = pos.m_7096_();
                v = new Vec3(x, y, z);
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                double z = pos.m_7098_();
                double y = -pos.m_7094_();
                double x = pos.m_7096_();
                v = new Vec3(x, y, z);
            }
        } else if (rotation == Rotation.CLOCKWISE_90) {
            double z = pos.m_7094_();
            double y = pos.m_7096_();
            double x = -pos.m_7098_();
            v = new Vec3(x, y, z);
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            double z = pos.m_7094_();
            double y = -pos.m_7096_();
            double x = pos.m_7098_();
            v = new Vec3(x, y, z);
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            v = BlockPosHelper.rotateVertical(BlockPosHelper.rotateVertical(pos, Rotation.CLOCKWISE_90, axis), Rotation.CLOCKWISE_90, axis);
        }
        return v;
    }

    private static BlockPos rotateVertical(BlockPos pos, Direction dir) {
        if (dir == Direction.UP) {
            int z = -pos.m_123342_();
            int y = pos.m_123343_();
            int x = pos.m_123341_();
            return new BlockPos(x, y, z);
        }
        if (dir == Direction.DOWN) {
            int z = pos.m_123342_();
            int y = -pos.m_123343_();
            int x = pos.m_123341_();
            return new BlockPos(x, y, z);
        }
        return pos;
    }

    public static int getDegrees(Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> 90;
            case Rotation.CLOCKWISE_180 -> 180;
            case Rotation.COUNTERCLOCKWISE_90 -> 270;
            default -> 0;
        };
    }

    public static Rotation getRotation(Direction dir) {
        return BlockPosHelper.getRotationBetween(Direction.SOUTH, dir);
    }

    public static Rotation getRotationBack(Direction dir) {
        return BlockPosHelper.getRotationBetween(dir, Direction.SOUTH);
    }

    public static Rotation getRotationBetween(Direction dir1, Direction dir2) {
        if (dir1 == null) {
            dir1 = Direction.SOUTH;
        }
        if (dir2 == null) {
            dir2 = Direction.SOUTH;
        }
        if (dir1 == dir2) {
            return Rotation.NONE;
        }
        if (dir1 == Direction.UP || dir1 == Direction.DOWN) {
            if (dir2 != Direction.DOWN && dir2 != Direction.UP) {
                return BlockPosHelper.rotate180(BlockPosHelper.getRotationBetween(dir2, dir1));
            }
            return Rotation.CLOCKWISE_180;
        }
        if (dir1 == Direction.SOUTH) {
            if (dir2 == Direction.WEST || dir2 == Direction.UP) {
                return Rotation.CLOCKWISE_90;
            }
            if (dir2 == Direction.NORTH) {
                return Rotation.CLOCKWISE_180;
            }
            if (dir2 == Direction.EAST || dir2 == Direction.DOWN) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        if (dir1 == Direction.WEST) {
            if (dir2 == Direction.NORTH || dir2 == Direction.UP) {
                return Rotation.CLOCKWISE_90;
            }
            if (dir2 == Direction.EAST) {
                return Rotation.CLOCKWISE_180;
            }
            if (dir2 == Direction.SOUTH || dir2 == Direction.DOWN) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        if (dir1 == Direction.NORTH) {
            if (dir2 == Direction.EAST || dir2 == Direction.UP) {
                return Rotation.CLOCKWISE_90;
            }
            if (dir2 == Direction.SOUTH) {
                return Rotation.CLOCKWISE_180;
            }
            if (dir2 == Direction.WEST || dir2 == Direction.DOWN) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        if (dir1 == Direction.EAST) {
            if (dir2 == Direction.SOUTH || dir2 == Direction.UP) {
                return Rotation.CLOCKWISE_90;
            }
            if (dir2 == Direction.WEST) {
                return Rotation.CLOCKWISE_180;
            }
            if (dir2 == Direction.NORTH || dir2 == Direction.DOWN) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static double dist(Vec3i vec1, int vec2X, int vec2Y, int vec2Z) {
        return BlockPosHelper.dist(vec1, new Vec3i(vec2X, vec2Y, vec2Z));
    }

    public static double dist(Vec3i vec1, Vec3i vec2) {
        double d0 = vec1.m_123341_() - vec2.m_123341_();
        double d1 = vec1.m_123342_() - vec2.m_123342_();
        double d2 = vec1.m_123343_() - vec2.m_123343_();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public static int getIntRotation(Direction facing, boolean inverted) {
        return switch (facing) {
            case Direction.EAST, Direction.DOWN -> {
                if (inverted) {
                    yield 90;
                }
                yield 270;
            }
            case Direction.SOUTH -> {
                if (!inverted) {
                    yield 180;
                }
                yield 0;
            }
            case Direction.WEST, Direction.UP -> {
                if (!inverted) {
                    yield 90;
                }
                yield 270;
            }
            default -> inverted ? 180 : 0;
        };
    }

    public static int getIntDHDRotationFromFacing(Direction facing, boolean inverted) {
        return (int)Math.floor((float)BlockPosHelper.getIntRotation(facing, inverted) / 360.0f * 16.0f);
    }

    public static Direction rotateDir(Direction dir, Rotation rot) {
        int count = 0;
        if (rot == Rotation.CLOCKWISE_90) {
            count = 1;
        }
        if (rot == Rotation.CLOCKWISE_180) {
            count = 2;
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            count = 3;
        }
        for (int i = 0; i < count; ++i) {
            dir = dir.m_122427_();
        }
        return dir;
    }

    public static int rotateDHDDir(int dir, Rotation rot) {
        int count = 0;
        if (rot == Rotation.CLOCKWISE_90) {
            count = 1;
        }
        if (rot == Rotation.CLOCKWISE_180) {
            count = 2;
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            count = 3;
        }
        for (int i = 0; i < count; ++i) {
            dir += 4;
            dir %= 16;
        }
        return dir;
    }

    public static Direction flipDir(Direction dir, Mirror mirror) {
        if (mirror == null) {
            return dir;
        }
        if (mirror == Mirror.FRONT_BACK && dir.m_122434_() == Direction.Axis.X) {
            return dir.m_122424_();
        }
        if (mirror == Mirror.LEFT_RIGHT && dir.m_122434_() == Direction.Axis.Z) {
            return dir.m_122424_();
        }
        return dir;
    }

    public static BlockPos getPos(Vec3 vector) {
        return new BlockPos((int)vector.f_82479_, (int)vector.f_82480_, (int)vector.f_82481_);
    }

    public static Vec3 getVec3(Vec3i vector) {
        return new Vec3((double)vector.m_123341_(), (double)vector.m_123342_(), (double)vector.m_123343_());
    }
}

