/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.util.ILinkable;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.RegistryObject;

public class LinkingHelper {
    @Nullable
    public static BlockPos findClosestUnlinked(Level world, BlockPos startPos, BlockPos radius, RegistryObject<?>[] allowedBlocks) {
        Block[] b = new Block[allowedBlocks.length];
        for (int i = 0; i < allowedBlocks.length; ++i) {
            Block bb;
            Object object = allowedBlocks[i].get();
            b[i] = object instanceof Block ? (bb = (Block)object) : null;
        }
        return LinkingHelper.findClosestUnlinked(world, startPos, radius, b);
    }

    @Nullable
    public static BlockPos findClosestUnlinked(Level world, BlockPos startPos, BlockPos radius, Block targetBlock) {
        return LinkingHelper.findClosestUnlinked(world, startPos, radius, new Block[]{targetBlock});
    }

    @Nullable
    public static BlockPos findClosestUnlinked(Level world, BlockPos startPos, BlockPos radius, Block[] targetBlocks) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        block0: for (BlockPos target : BlockPos.m_121940_((BlockPos)startPos.m_121996_((Vec3i)radius), (BlockPos)startPos.m_121955_((Vec3i)radius))) {
            for (Block targetBlock : targetBlocks) {
                ILinkable linkedTile;
                BlockEntity blockEntity;
                if (world.m_8055_(target).m_60734_() != targetBlock || !((blockEntity = world.m_7702_(target)) instanceof ILinkable) || !(linkedTile = (ILinkable)blockEntity).canLinkTo()) continue;
                double distanceSq = startPos.m_123331_((Vec3i)target);
                if (!(distanceSq < closestDistance)) continue block0;
                closestDistance = distanceSq;
                closest = target.m_7949_();
                continue block0;
            }
        }
        return closest;
    }

    @Nullable
    public static BlockPos findClosestPos(Level world, BlockPos startPos, BlockPos radius, RegistryObject<?>[] targetBlocks, ArrayList<BlockPos> blacklist) {
        if (targetBlocks == null) {
            return null;
        }
        if (targetBlocks.length == 0) {
            return null;
        }
        Block[] b = new Block[targetBlocks.length];
        for (int i = 0; i < targetBlocks.length; ++i) {
            Block bb;
            Object object = targetBlocks[i].get();
            b[i] = object instanceof Block ? (bb = (Block)object) : null;
        }
        return LinkingHelper.findClosestPos(world, startPos, radius, b, blacklist);
    }

    @Nullable
    public static BlockPos findClosestPos(Level world, BlockPos startPos, BlockPos radius, Block[] targetBlocks, ArrayList<BlockPos> blacklist) {
        if (targetBlocks == null) {
            return null;
        }
        if (targetBlocks.length == 0) {
            return null;
        }
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        block0: for (BlockPos target : BlockPos.m_121940_((BlockPos)startPos.m_121996_((Vec3i)radius), (BlockPos)startPos.m_121955_((Vec3i)radius))) {
            for (Block targetBlock : targetBlocks) {
                if (world.m_8055_(target).m_60734_() != targetBlock || blacklist.contains(target)) continue;
                double distanceSq = startPos.m_123331_((Vec3i)target);
                if (!(distanceSq < closestDistance)) continue block0;
                closestDistance = distanceSq;
                closest = target.m_7949_();
                continue block0;
            }
        }
        return closest;
    }

    public static <T extends BlockEntity> T findClosestTile(Level world, BlockPos startPos, RegistryObject<?>[] allowedBlocks, Class<T> tileClass, int radiusXZ, int radiusY) {
        Block[] b = new Block[allowedBlocks.length];
        for (int i = 0; i < allowedBlocks.length; ++i) {
            Block bb;
            Object object = allowedBlocks[i].get();
            b[i] = object instanceof Block ? (bb = (Block)object) : null;
        }
        return LinkingHelper.findClosestTile(world, startPos, b, tileClass, radiusXZ, radiusY);
    }

    public static <T extends BlockEntity> T findClosestTile(Level world, BlockPos startPos, Block[] allowedBlocks, Class<T> tileClass, int radiusXZ, int radiusY) {
        BlockPos found = null;
        BlockEntity tileEntity = null;
        ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
        while (found == null && (found = LinkingHelper.findClosestPos(world, startPos, new BlockPos(radiusXZ, radiusY, radiusXZ), allowedBlocks, blacklist)) != null) {
            BlockEntity tile = world.m_7702_(found);
            if (!tileClass.isInstance(tile)) {
                blacklist.add(found);
                continue;
            }
            tileEntity = tile;
        }
        return (T)tileEntity;
    }

    public static BlockPos getDhdRange() {
        int xz = (Integer)JSGConfig.DialHomeDevice.rangeFlat.get();
        int y = (Integer)JSGConfig.DialHomeDevice.rangeVertical.get();
        return new BlockPos(xz, y, xz);
    }

    public static void updateLinkedGate(Level world, BlockPos gatePos, BlockPos dhdPos) {
        StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(gatePos);
        DHDAbstractBE dhdTile = (DHDAbstractBE)world.m_7702_(dhdPos);
        if (dhdTile != null && gateTile instanceof ILinkable) {
            dhdTile.setLinkedDevice(gatePos);
            ((ILinkable)((Object)gateTile)).setLinkedDevice(dhdPos);
        }
    }
}

