/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import com.google.common.collect.ImmutableList;
import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.block.stargate.StargateAbstractMemberBlock;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.helpers.TemperatureHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class StargateTemperatureHelper {
    public static final PerlinSimplexNoise TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public static double getTemperatureAroundGate(StargateClassicBaseBE baseBE) {
        Level level = baseBE.m_58904_();
        if (level == null) {
            return 0.0;
        }
        double suma = 0.0;
        int count = 0;
        for (BlockPos member : baseBE.getMergeHelper().getBlocks().keySet()) {
            for (Direction direction : Direction.values()) {
                BlockPos posOffset = member.m_121955_(direction.m_122436_());
                BlockState state = level.m_8055_(posOffset);
                Double temp = StargateTemperatureHelper.getBlockTemperature(state, level, posOffset);
                if (temp == null) continue;
                suma += temp.doubleValue();
                ++count;
            }
        }
        if (count == 0) {
            return 20.0;
        }
        return suma / (double)count;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static Double getBlockTemperature(BlockState state, Level level, BlockPos pos) {
        if (state.m_60734_() instanceof StargateAbstractBaseBlock || state.m_60734_() instanceof StargateAbstractMemberBlock) {
            return null;
        }
        if (FluidHelper.isLiquidBlock(state)) {
            Fluid fluid = state.m_60819_().m_76152_();
            Block block = state.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquid = (LiquidBlock)block;
                fluid = liquid.getFluid();
            }
            if (fluid != Fluids.f_76191_) {
                return TemperatureHelper.asKelvins(fluid.getFluidType().getTemperature()).toCelsius();
            }
        }
        return (StargateTemperatureHelper.getTemperature(state, level, (Biome)level.m_204166_(pos).get(), pos) - 0.4f) * 25.0f;
    }

    public static float getTemperature(BlockState state, Level level, Biome biome, BlockPos pos) {
        if (!state.m_247087_()) {
            if (state.m_204336_(BlockTags.f_144279_)) {
                return 0.2f;
            }
            if (state.m_204336_(BlockTags.f_13047_)) {
                return 0.120000005f;
            }
            if (state.m_60734_() == Blocks.f_50450_) {
                return 2.8000002f;
            }
            return (-11.0f + (float)state.m_60739_((BlockGetter)level, pos) + (float)level.m_45517_(LightLayer.BLOCK, pos) + 36.0f) / 56.0f * 2.0f;
        }
        float modifiedTemp = biome.getModifiedClimateSettings().f_47682_().m_8117_(pos, biome.m_47554_());
        if (pos.m_123342_() > 80) {
            float heightCoefficient = (float)(TEMPERATURE_NOISE.m_75449_((double)((float)pos.m_123341_() / 8.0f), (double)((float)pos.m_123343_() / 8.0f), false) * 8.0);
            return modifiedTemp - (heightCoefficient + (float)pos.m_123342_() - 80.0f) * 0.05f / 40.0f;
        }
        return modifiedTemp;
    }
}

