/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.item.ITabbedItem;
import dev.tauri.jsg.item.JSGBlockItem;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class TabHelper {
    public static final Map<String, List<Supplier<? extends ItemLike>>> TAB_ITEMS = new HashMap<String, List<Supplier<? extends ItemLike>>>();
    private static RegistryObject<CreativeModeTab> lastTab = null;

    @ParametersAreNonnullByDefault
    public static RegistryObject<CreativeModeTab> createCreativeTab(String name, Supplier<RegistryObject<? extends ItemLike>> iconObject) {
        RegistryObject<CreativeModeTab> lastTabForThisTab = lastTab;
        lastTab = TabRegistry.REGISTER.register(name, () -> {
            CreativeModeTab.Builder tab = CreativeModeTab.builder().m_257737_(() -> TabHelper.lambda$createCreativeTab$0((Supplier)iconObject, name)).m_257941_((Component)Component.m_237115_((String)("itemGroup.jsg_" + name))).m_257501_((parameters, output) -> {
                ItemLike item;
                List<Supplier<? extends ItemLike>> list = TAB_ITEMS.get(name);
                if (list == null) {
                    list = new ArrayList<Supplier<? extends ItemLike>>();
                    for (RegistryObject registryObject : ItemRegistry.REGISTER.getEntries().stream().toList()) {
                        ITabbedItem jsgItem;
                        item = (Item)registryObject.get();
                        if (!(item instanceof ITabbedItem) || (jsgItem = (ITabbedItem)item).getTab() == null || !jsgItem.getTab().getId().m_135815_().equalsIgnoreCase(name)) continue;
                        list.add((Supplier<? extends ItemLike>)registryObject);
                    }
                    TAB_ITEMS.put(name, list);
                }
                for (Supplier<? extends ItemLike> supplier : list) {
                    item = supplier.get();
                    output.m_246342_(new ItemStack(item));
                    if (!(item instanceof JSGBlockItem)) continue;
                    JSGBlockItem jsgItemBlock = (JSGBlockItem)item;
                    jsgItemBlock.addAdditional(output);
                }
            });
            if (lastTabForThisTab != null) {
                tab.withTabsBefore(new ResourceLocation[]{lastTabForThisTab.getId()});
            }
            return tab.m_257652_();
        });
        return lastTab;
    }

    private static /* synthetic */ ItemStack lambda$createCreativeTab$0(Supplier iconObject, String name) {
        if (iconObject.get() == null) {
            JSG.logger.error("Tab " + name + " has null icon!");
            return new ItemStack((ItemLike)Blocks.f_50016_);
        }
        return new ItemStack((ItemLike)((RegistryObject)iconObject.get()).get());
    }
}

