/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.cctweaked.methods;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.tauri.jsg.integration.cctweaked.CCDevices;
import dev.tauri.jsg.integration.cctweaked.methods.ICCDevice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCCMethods<TILE extends BlockEntity>
implements IPeripheral,
ICCDevice {
    protected final TILE deviceTile;
    protected final CCDevices device;
    protected final List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public AbstractCCMethods(TILE deviceTile, CCDevices device) {
        this.deviceTile = deviceTile;
        this.device = device;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Override
    public void sendSignal(String eventName, Object ... objects) {
        for (IComputerAccess computer : this.computers) {
            int length = objects.length + 1;
            Object[] attachmentObjects = new Object[length];
            attachmentObjects[0] = computer.getAttachmentName();
            System.arraycopy(objects, 0, attachmentObjects, 1, length - 1);
            computer.queueEvent(eventName, attachmentObjects);
        }
    }

    public String getType() {
        return this.device.deviceName;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof AbstractCCMethods && this.deviceTile == ((AbstractCCMethods)other).deviceTile;
    }
}

