/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.cctweaked.methods;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.integration.cctweaked.CCDevices;
import dev.tauri.jsg.integration.cctweaked.CCTweakedHelper;
import dev.tauri.jsg.integration.cctweaked.methods.AbstractCCMethods;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.NearbyGate;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.codesender.ComputerCodeSender;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateClassicCCMethods
extends AbstractCCMethods<StargateClassicBaseBE> {
    public StargateClassicCCMethods(BlockEntity deviceTile) {
        super((StargateClassicBaseBE)deviceTile, CCDevices.STARGATE_CLASSIC);
    }

    @LuaFunction(mainThread=true)
    public final Object[] getOpenedTime() {
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            String secondsString;
            int minutes;
            float openedSeconds = ((StargateClassicBaseBE)this.deviceTile).getOpenedSeconds();
            int seconds = (int)(openedSeconds - (float)(60 * (minutes = (int)Math.floor(openedSeconds / 60.0f))));
            String string = secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            if (openedSeconds > 0.0f) {
                return new Object[]{true, "stargate_time", "" + minutes, secondsString};
            }
            return new Object[]{false, "stargate_not_connected"};
        }
        return new Object[]{false, "stargate_not_connected"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] toggleIris() {
        if (((StargateClassicBaseBE)this.deviceTile).getIrisType() == EnumIrisType.NULL) {
            return new Object[]{false, "stargate_iris_missing", "Iris is not installed!"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getIrisMode() != EnumIrisMode.OC) {
            return new Object[]{false, "stargate_iris_error_mode", "Iris mode must be set to OC"};
        }
        boolean result = ((StargateClassicBaseBE)this.deviceTile).toggleIris();
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        if (!result && ((StargateClassicBaseBE)this.deviceTile).hasShieldIris() && ((StargateClassicBaseBE)this.deviceTile).isIrisOpened() && ((StargateClassicBaseBE)this.deviceTile).getEnergyStorage().getEnergyStored() < ((StargateClassicBaseBE)this.deviceTile).shieldKeepAlive * 3) {
            return new Object[]{false, "stargate_iris_not_power", "Not enough power to close shield"};
        }
        if (!result) {
            return new Object[]{false, "stargate_iris_busy", "Iris is busy"};
        }
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getIrisState() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisState().toString()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getIrisType() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisType().toString()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getIrisDurability() {
        ((StargateClassicBaseBE)this.deviceTile).updateIrisDurability();
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).irisDurability + "/" + ((StargateClassicBaseBE)this.deviceTile).irisMaxDurability, ((StargateClassicBaseBE)this.deviceTile).irisDurability, ((StargateClassicBaseBE)this.deviceTile).irisMaxDurability};
    }

    @LuaFunction(mainThread=true)
    public final Object[] sendMessageToIncoming(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            return new Object[]{null, "stargate_failure_not_engaged", "Stargate is not engaged"};
        }
        Optional msg = args.optString(0);
        if (msg.isEmpty()) {
            return new Object[]{false, "wrong_argument_type"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).codeSender != null && ((StargateClassicBaseBE)this.deviceTile).codeSender.canReceiveMessage()) {
            ((StargateClassicBaseBE)this.deviceTile).codeSender.sendMessage((Component)Component.m_237113_((String)((String)msg.get())));
            return new Object[]{true, "success"};
        }
        return new Object[]{false, "no_listener_available"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] sendIrisCode(ILuaContext ctx, IArguments args) throws LuaException {
        String code = args.getString(0);
        if (code == null) {
            return new Object[]{false, "invalid_method_format", "You must enter code!"};
        }
        StargatePos destinationPos = StargateNetwork.INSTANCE.getStargate(((StargateClassicBaseBE)this.deviceTile).getDialedAddress());
        if (destinationPos == null) {
            return new Object[]{false, "stargate_not_engaged"};
        }
        StargateAbstractBaseBE te = destinationPos.getBlockEntity();
        if (!(te instanceof StargateClassicBaseBE)) {
            return new Object[]{false, "invalid_target_gate"};
        }
        StargateClassicBaseBE classicTile = (StargateClassicBaseBE)te;
        classicTile.receiveIrisCode(new ComputerCodeSender(StargateNetwork.INSTANCE.getStargate(((StargateClassicBaseBE)this.deviceTile).getStargateAddress(SymbolTypeRegistry.MILKYWAY))), code);
        return new Object[]{true, "success"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] abortDialing() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().dialingComputer() || ((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            ((StargateClassicBaseBE)this.deviceTile).abortDialingSequence();
            ((StargateClassicBaseBE)this.deviceTile).m_6596_();
            return new Object[]{null, "stargate_aborting", "Aborting dialing"};
        }
        return new Object[]{null, "stargate_aborting_failed", "Aborting dialing failed"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] engageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            StargateOpenResult gateState = ((StargateClassicBaseBE)this.deviceTile).attemptOpenAndFail();
            if (gateState.ok()) {
                return new Object[]{"stargate_engage"};
            }
            return new Object[]{null, "stargate_failure_opening", "Stargate failed to open", gateState.toString()};
        }
        return new Object[]{null, "stargate_failure_busy", "Stargate is busy", ((StargateClassicBaseBE)this.deviceTile).getStargateState().toString()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] disengageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            if (((StargateClassicBaseBE)this.deviceTile).getStargateState().initiating()) {
                ((StargateClassicBaseBE)this.deviceTile).attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{"stargate_disengage"};
            }
            return new Object[]{null, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{null, "stargate_failure_not_open", "The gate is closed"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] engageSymbol(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + String.valueOf((Object)((StargateClassicBaseBE)this.deviceTile).getStargateState())};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getDialedAddress().size() == 9) {
            return new Object[]{null, "stargate_failure_full", "Already dialed 9 chevrons"};
        }
        Object symbol = args.get(0);
        SymbolInterface targetSymbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbol);
        if (!targetSymbol.isValidForAddress() && !targetSymbol.origin()) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        ((StargateClassicBaseBE)this.deviceTile).addSymbolToAddressManual(targetSymbol, "oc_used");
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        return new Object[]{"stargate_spin"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] dialAddress(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + String.valueOf((Object)((StargateClassicBaseBE)this.deviceTile).getStargateState())};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getDialedAddress().size() > 0) {
            return new Object[]{null, "stargate_failure_not_empty", "Dialed address is not empty"};
        }
        LinkedList<Object> argsParsed = new LinkedList<Object>();
        for (int i = 0; i < args.getAll().length; ++i) {
            argsParsed.add(args.get(i));
        }
        if (args.getAll().length > 0 && args.getType(0).equalsIgnoreCase("table")) {
            Map table = args.getTable(0);
            argsParsed = CCTweakedHelper.getCorrectlyOrderedTableValues(table);
        }
        if (argsParsed.size() < 7) {
            return new Object[]{null, "input_address_malformed", "Input address is malformed"};
        }
        int maxSymbols = Math.min(argsParsed.size(), 9);
        StargateAddressDynamic address = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        for (int i = 0; i < maxSymbols; ++i) {
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(argsParsed.get(i));
            if (!symbol.isValidForAddress() && !symbol.origin()) {
                throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
            }
            address.addSymbol(symbol);
        }
        ((StargateClassicBaseBE)this.deviceTile).dialAddress(address, maxSymbols, false, EnumDialingType.NORMAL);
        return new Object[]{"dial_begun", address.toString()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] spinGate(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getSymbolType() == SymbolTypeRegistry.PEGASUS) {
            return new Object[]{null, "stargate_not_supported", "Stargate type is not supported"};
        }
        int time = args.getInt(0);
        boolean changeState = args.getBoolean(1);
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().idle()) {
            if (time != 0) {
                ((StargateClassicBaseBE)this.deviceTile).spinRing(1, changeState, true, time);
                return new Object[]{null, "stargate_spin"};
            }
            return new Object[]{null, "stargate_failure_wrong_usage", "Time is 0"};
        }
        return new Object[]{null, "stargate_failure_not_idle", "The gate is not idle"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getCapacitorsInstalled() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).isMerged() ? Integer.valueOf(((StargateClassicBaseBE)this.deviceTile).currentPowerTier - 1) : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getGateType() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).isMerged() ? ((StargateClassicBaseBE)this.deviceTile).getStargateType().toString() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolType() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).isMerged() ? ((StargateClassicBaseBE)this.deviceTile).getSymbolType().getId() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolsMap() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).isMerged() ? Arrays.stream(((StargateClassicBaseBE)this.deviceTile).getSymbolType().getValues()).map(SymbolInterface::getEnglishName).toList() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getGateStatus() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getStargateState().engaged()) {
            return new Object[]{"open", ((StargateClassicBaseBE)this.deviceTile).getStargateState().initiating()};
        }
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getStargateState().toString().toLowerCase()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolsNeeded(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        LinkedList<Object> symbols = CCTweakedHelper.getCorrectlyOrderedTableValues(args.getTable(0));
        for (Object e : symbols) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(e);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        StargatePos pos = StargateNetwork.INSTANCE.getStargate(stargateAddress);
        if (pos == null) {
            return new Object[]{"gate_not_found"};
        }
        int n = ((StargateClassicBaseBE)this.deviceTile).getMinimalSymbolsToDial(pos.getGateSymbolType(), pos);
        return new Object[]{true, n};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getEnergyRequiredToDial(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        LinkedList<Object> symbols = CCTweakedHelper.getCorrectlyOrderedTableValues(args.getTable(0));
        for (Object e : symbols) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(e);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!((StargateClassicBaseBE)this.deviceTile).canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        EnergyRequiredToOperate energyRequired = ((StargateClassicBaseBE)this.deviceTile).getEnergyRequiredToDial(Objects.requireNonNull(StargateNetwork.INSTANCE.getStargate(stargateAddress)));
        HashMap<String, Constable> hashMap = new HashMap<String, Constable>(2);
        hashMap.put("open", Integer.valueOf(energyRequired.energyToOpen));
        hashMap.put("keepAlive", Integer.valueOf(energyRequired.keepAlive));
        hashMap.put("canOpen", Boolean.valueOf(((StargateClassicBaseBE)this.deviceTile).getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen));
        return new Object[]{hashMap};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getNearbyGates(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{null, false, "gate_not_merged", new HashMap()};
        }
        String gateType = args.getString(0);
        boolean checkGateType = args.getBoolean(1);
        boolean checkAddressAndEnergy = args.getBoolean(2);
        HashMap<String, Map> map = new HashMap<String, Map>();
        StargateTypeEnum symbolType = StargateTypeEnum.valueOf(gateType.toUpperCase());
        for (NearbyGate g : ((StargateClassicBaseBE)this.deviceTile).getNearbyGates(symbolType, checkGateType, checkAddressAndEnergy)) {
            Map map2 = map.computeIfAbsent(g.address.getSymbolType().toString(), k -> new HashMap());
            map2.put(g.address.getNameList(), g.symbolsNeeded);
            map.put(g.gateType.toString(), map2);
        }
        return new Object[]{null, true, "success", map};
    }
}

