/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.create;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.integration.create.CreateTeleportEntityManager;
import dev.tauri.jsg.integration.create.TeleportTrackManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.ModList;

public class CreateIntegrationManager {
    public static boolean isCreateLoaded = false;

    public static void registerCreate() {
        isCreateLoaded = ModList.get().isLoaded("create");
    }

    public static boolean canStargateTeleport(Entity e) {
        if (!isCreateLoaded) {
            return true;
        }
        return CreateTeleportEntityManager.canStargateTeleport(e);
    }

    public static void markPassengersAsTeleported(Entity train, StargateAbstractBaseBE targetGate) {
        if (!isCreateLoaded) {
            return;
        }
        CreateTeleportEntityManager.markPassengersAsTeleported(train, targetGate);
    }

    public static void tickTracksAroundStargate(StargateClassicBaseBE gateTile) {
        if (!isCreateLoaded) {
            return;
        }
        if (gateTile.m_58904_() == null || gateTile.m_58904_().f_46443_) {
            return;
        }
        if (gateTile.getFacingVertical() != Direction.SOUTH) {
            return;
        }
        if (!gateTile.isMerged()) {
            return;
        }
        Direction facing = gateTile.getFacing();
        BlockPos pos = gateTile.m_58899_().m_6630_(2).m_121955_(facing.m_122436_());
        ServerLevel level = (ServerLevel)gateTile.getLevelNotNull();
        TeleportTrackManager.connectThroughStargate(level, pos, level.m_8055_(pos), facing, null);
    }

    public static void removeTeleportTracksAroundStargate(StargateClassicBaseBE gateTile) {
        if (!isCreateLoaded) {
            return;
        }
        if (gateTile.m_58904_() == null || gateTile.m_58904_().f_46443_) {
            return;
        }
        if (gateTile.getFacingVertical() != Direction.SOUTH) {
            return;
        }
        Direction facing = gateTile.getFacing();
        BlockPos pos = gateTile.m_58899_().m_6630_(2).m_121955_(facing.m_122436_());
        ServerLevel level = (ServerLevel)gateTile.getLevelNotNull();
        TeleportTrackManager.connectThroughStargate(level, pos, level.m_8055_(pos), facing, false);
    }
}

