/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.jei.recipes.cauldron;

import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.integration.jei.category.CauldronRecipeType;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidCauldronRecipe
implements CauldronRecipeType.CauldronRecipeTypeFluid {
    public final Supplier<ItemStack> inputSupplier;
    public final Supplier<Fluid> fluid;
    public final Supplier<Pair<Fluid, ItemStack>> outputSupplier;

    public FluidCauldronRecipe(Supplier<ItemStack> inputSupplier, Supplier<Fluid> fluid, FluidHelper.MoltenFluid outputSupplier) {
        this(inputSupplier, fluid, () -> Pair.of((Object)outputSupplier.get(), (Object)new ItemStack((ItemLike)outputSupplier.bucket.get(), 1)));
    }

    public FluidCauldronRecipe(Supplier<ItemStack> inputSupplier, Supplier<Fluid> fluid, Supplier<Pair<Fluid, ItemStack>> outputSupplier) {
        this.inputSupplier = inputSupplier;
        this.fluid = fluid;
        this.outputSupplier = outputSupplier;
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.inputSupplier.get();
    }

    @Override
    @NotNull
    public FluidStack getFluid() {
        return new FluidStack(this.fluid.get(), 1000);
    }

    @Override
    public void setResult(IRecipeLayoutBuilder builder, CauldronRecipeType recipe, IFocusGroup focuses) {
        Pair<Fluid, ItemStack> o = this.outputSupplier.get();
        Fluid fluid = (Fluid)o.first();
        ItemStack bucket = (ItemStack)o.second();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addFluidStack(fluid, 1000L)).setFluidRenderer(1000L, false, 16, 11);
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(bucket);
    }
}

