/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item;

import dev.tauri.jsg.block.WrenchRotatable;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.item.JSGItem;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.registry.TagsRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class JSGWrench
extends JSGItem {
    public JSGWrench() {
        super(new Item.Properties().m_41487_(1), TabRegistry.TAB_TOOLS);
    }

    @ParametersAreNonnullByDefault
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_5524_(), components, tooltipFlag);
        components.add((Component)Component.m_237119_());
        components.add((Component)Component.m_237113_((String)(String.format("%.2f", (double)(this.getMaxDamage(stack) - this.getDamage(stack)) / (double)this.getMaxDamage(stack) * 100.0) + "%")).m_130940_(ChatFormatting.GRAY));
    }

    @Nonnull
    public ItemStack m_7968_() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        this.setDamage(itemStack, 0);
        return itemStack;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        return enchantment instanceof DigDurabilityEnchantment;
    }

    public int m_6473_() {
        return 3;
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
        if (this.getMaxDamage(stack) <= damage) {
            stack.m_41764_(0);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return 255;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack it = itemStack.m_41777_();
        it.m_41721_(itemStack.m_41773_() + 1);
        return it;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos pos = pContext.m_8083_();
        BlockState state = pContext.m_43725_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof WrenchRotatable) {
            WrenchRotatable rotatable = (WrenchRotatable)block;
            rotatable.onWrenchUse(state, pContext);
            return InteractionResult.m_19078_((boolean)pContext.m_43725_().m_5776_());
        }
        if (state.m_204336_(TagsRegistry.WRENCH_ROTATABLE)) {
            state = state.rotate((LevelAccessor)pContext.m_43725_(), pos, Rotation.CLOCKWISE_90);
            pContext.m_43725_().m_7731_(pos, state, 3);
            return InteractionResult.m_19078_((boolean)pContext.m_43725_().m_5776_());
        }
        return InteractionResult.PASS;
    }
}

