/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.energy;

import dev.tauri.jsg.capability.ItemCapabilityProvider;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.item.JSGBlockItem;
import dev.tauri.jsg.power.general.ItemEnergyStorage;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapacitorItemBlock
extends JSGBlockItem
implements IForgeItem {
    public final boolean creative;

    public CapacitorItemBlock(Block b, boolean creative) {
        super(b, new Item.Properties().m_41487_(1), TabRegistry.TAB_ENERGY);
        this.creative = creative;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, nbt, (Integer)JSGConfig.Stargate.stargateEnergyStorage.get() / 4, this.creative);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (this.creative) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).resolve().get();
        String energy = String.format("%,d", energyStorage.getEnergyStored());
        String capacity = String.format("%,d", energyStorage.getMaxEnergyStored());
        components.add((Component)Component.m_237113_((String)("\u00a77" + energy + " / " + capacity + " RF")));
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() * 100.0f)) + " %";
        components.add((Component)Component.m_237113_((String)("\u00a77" + energyPercent)));
    }

    public boolean m_142522_(@NotNull ItemStack itemStack) {
        return !this.creative;
    }

    public int m_142158_(@NotNull ItemStack itemStack) {
        if (this.creative) {
            return 13;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY, null).resolve().get();
        return (int)((double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored() * 13.0);
    }

    public int m_142159_(@NotNull ItemStack itemStack) {
        float f = (float)this.m_142158_(itemStack) / 13.0f;
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public void addAdditional(CreativeModeTab.Output output) {
        if (this.creative) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        Optional caps = stack.getCapability(ForgeCapabilities.ENERGY, null).resolve();
        if (caps.isEmpty()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)caps.get();
        if (!(energyStorage instanceof ItemEnergyStorage)) {
            return;
        }
        ItemEnergyStorage itemEnergyStorage = (ItemEnergyStorage)energyStorage;
        itemEnergyStorage.setEnergyStored(((IEnergyStorage)caps.get()).getMaxEnergyStored());
        output.m_246342_(stack);
    }
}

