/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.item.JSGItem;
import dev.tauri.jsg.item.linkable.HandHeldDeviceUtils;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerBEWLR;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.NearbyGate;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.util.I18n;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class UniverseDialerItem
extends JSGItem {
    public UniverseDialerItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON), TabRegistry.TAB_TOOLS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final UniverseDialerBEWLR instance = new UniverseDialerBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        CompoundTag compound;
        block16: {
            BlockPos targetPos;
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_()) {
                CompoundTag compound2 = new CompoundTag();
                compound2.m_128344_("mode", UniverseDialerMode.NEARBY.id);
                compound2.m_128344_("selected", (byte)0);
                compound2.m_128365_("saved", (Tag)new ListTag());
                stack.m_41751_(compound2);
                return;
            }
            compound = stack.m_41783_();
            boolean wasLinked = false;
            if (world.m_46467_() % 20L != 0L || !isSelected || compound == null) break block16;
            BlockPos pos = entity.m_20183_();
            int reachSquared = (Integer)JSGConfig.DialHomeDevice.universeDialerReach.get() * (Integer)JSGConfig.DialHomeDevice.universeDialerReach.get() * 2;
            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.m_128445_("mode"));
            compound.m_128379_("serverSideEnabledFastDial", false);
            compound.m_128405_("biomeOverlay", BiomeOverlayEnum.updateBiomeOverlay(world, pos, EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST)).ordinal());
            if (!mode.linkable) break block16;
            if (compound.m_128441_(mode.tagPosName)) {
                wasLinked = true;
                BlockPos tilePos = BlockPos.m_122022_((long)compound.m_128454_(mode.tagPosName));
                if (!BlockRegistry.isInBlocksArray(world.m_8055_(tilePos).m_60734_(), mode.matchBlocks) || tilePos.m_123331_((Vec3i)pos) > (double)reachSquared) {
                    compound.m_128473_(mode.tagPosName);
                }
            }
            boolean found = false;
            ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
            int loop = 0;
            while ((targetPos = this.getNearest(world, pos, blacklist, mode)) != null) {
                block17: {
                    switch (mode) {
                        case MEMORY: 
                        case NEARBY: {
                            StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(targetPos);
                            if (gateTile != null && gateTile.isMerged() && gateTile instanceof StargateUniverseBaseBE) {
                                StargateUniverseBaseBE uniTile = (StargateUniverseBaseBE)gateTile;
                                ListTag nearbyList = new ListTag();
                                try {
                                    HandHeldDeviceUtils.addrToBytes(gateTile.getDialedAddress(), compound, "dialedAddress");
                                    HandHeldDeviceUtils.addrToBytes(uniTile.getAddressToDial(), compound, "toDialAddress");
                                    compound.m_128405_("gateStatus", gateTile.getStargateState().id);
                                    compound.m_128379_("serverSideEnabledFastDial", ((Boolean)((JSGBooleanConfigOption)uniTile.getConfig().getOption("enableFastDial")).getValue()).booleanValue());
                                    ArrayList<NearbyGate> foundList = uniTile.getNearbyGates(StargateTypeEnum.UNIVERSE, false, false);
                                    if (foundList != null) {
                                        for (NearbyGate gate : foundList) {
                                            CompoundTag entryCompound = gate.address.serializeNBT();
                                            entryCompound.m_128385_("symbolsToDisplay", gate.getSymbolsToDisplay());
                                            nearbyList.add((Object)entryCompound);
                                        }
                                    }
                                    compound.m_128365_(UniverseDialerMode.NEARBY.tagListName, (Tag)nearbyList);
                                    compound.m_128356_(mode.tagPosName, targetPos.m_121878_());
                                    found = true;
                                }
                                catch (ConcurrentModificationException e) {
                                    JSG.logger.error("Error while iterating nearby stargates occurred", (Throwable)e);
                                    if (!(entity instanceof ServerPlayer)) break;
                                    ServerPlayer p = (ServerPlayer)entity;
                                    p.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.dialer_broke"), true);
                                }
                                break;
                            }
                            blacklist.add(targetPos);
                            break block17;
                        }
                        case GATE_INFO: {
                            BlockEntity tile = world.m_7702_(targetPos);
                            if (!(tile instanceof StargateClassicBaseBE)) break;
                            StargateClassicBaseBE t = (StargateClassicBaseBE)tile;
                            Optional<JSGConfigOption<?>> o = t.getConfig().getOptionMaybe("enableFastDial");
                            compound.m_128379_("serverSideEnabledFastDial", o.map(jsgConfigOption -> (Boolean)((JSGBooleanConfigOption)jsgConfigOption).getValue()).orElse(false).booleanValue());
                            compound.m_128405_("gateStatus", t.getStargateState().id);
                            compound.m_128359_("gateOpenTime", t.getOpenedSeconds() > 0L ? t.getOpenedSecondsToDisplayAsMinutes() : "CLOSED");
                            compound.m_128359_("gateIrisState", t.hasIris() ? t.getIrisState().toString() : "MISSING");
                            compound.m_128359_("gateLastSymbol", (String)(t.getDialedAddress().size() > 0 ? t.getDialedAddress().get(t.getDialedAddress().size() - 1).toString() + " (" + t.getDialedAddress().size() + ")" : "-- (0)"));
                            if (t.getStargateState().notInitiating()) {
                                compound.m_128359_("gateLastSymbol", "INCOMING");
                            }
                            compound.m_128356_(mode.tagPosName, targetPos.m_121878_());
                            found = true;
                        }
                    }
                    if (found && !wasLinked && entity instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)entity;
                        JSGSoundHelper.playSoundToPlayer(sp, SoundEventEnum.UNIVERSE_DIALER_CONNECTED, entity.m_20183_());
                    }
                    ++loop;
                }
                if (!found && loop < 100) continue;
            }
        }
        stack.m_41751_(compound);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_5524_(), components, tooltipFlag);
        if (!stack.m_41782_()) {
            return;
        }
        ListTag list = Objects.requireNonNull(stack.m_41783_()).m_128437_("saved", 10);
        components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + I18n.format("item.jsg.universe_dialer.saved_gates", list.size()))));
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compound = list.m_128728_(i);
            if (!compound.m_128441_("name")) continue;
            components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + compound.m_128461_("name"))));
        }
    }

    public BlockPos getNearest(Level world, BlockPos pos, ArrayList<BlockPos> blacklist, UniverseDialerMode mode) {
        return LinkingHelper.findClosestPos(world, pos, new BlockPos(((Integer)JSGConfig.DialHomeDevice.universeDialerReach.get()).intValue(), 40, ((Integer)JSGConfig.DialHomeDevice.universeDialerReach.get()).intValue()), mode.matchBlocks, blacklist);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.f_46443_ && player.m_21120_(hand).m_41782_()) {
            StargateUniverseBaseBE gateTile;
            ItemStack stack = player.m_21120_(hand);
            boolean shift = player.m_6144_();
            CompoundTag compound = stack.m_41783_();
            UniverseDialerMode mode = UniverseDialerMode.valueOf(Objects.requireNonNull(compound).m_128445_("mode"));
            byte selected = compound.m_128445_("selected");
            if (mode.linkable && !compound.m_128441_(mode.tagPosName)) {
                return super.m_7203_(world, player, hand);
            }
            BlockPos linkedPos = BlockPos.m_122022_((long)compound.m_128454_(mode.tagPosName));
            ListTag tagList = compound.m_128437_(mode.tagListName, 10);
            BlockEntity linkedTe = world.m_7702_(linkedPos);
            if (shift && linkedTe instanceof StargateUniverseBaseBE && (gateTile = (StargateUniverseBaseBE)linkedTe).hasIris() && gateTile.getIrisMode() == EnumIrisMode.DIALER) {
                gateTile.toggleIris();
                return super.m_7203_(world, player, hand);
            }
            if (selected >= tagList.size()) {
                return super.m_7203_(world, player, hand);
            }
            CompoundTag selectedCompound = tagList.m_128728_((int)selected);
            block0 : switch (mode) {
                case MEMORY: 
                case NEARBY: {
                    StargateUniverseBaseBE gateTile2 = (StargateUniverseBaseBE)linkedTe;
                    if (gateTile2 == null) break;
                    switch (gateTile2.getStargateState()) {
                        case IDLE: {
                            int[] symbolsToDisplay = selectedCompound.m_128465_("symbolsToDisplay");
                            StargateAddress address = new StargateAddress(selectedCompound);
                            gateTile2.dialAddress(address, Math.min(address.getSize(), symbolsToDisplay.length - (mode == UniverseDialerMode.NEARBY ? 1 : 0)), false, EnumDialingType.NORMAL);
                            player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.dial_start"), true);
                            if (!(player instanceof ServerPlayer)) break block0;
                            ServerPlayer sp = (ServerPlayer)player;
                            JSGSoundHelper.playSoundToPlayer(sp, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                            break;
                        }
                        case ENGAGED_INITIATING: {
                            gateTile2.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            if (!(player instanceof ServerPlayer)) break block0;
                            ServerPlayer sp = (ServerPlayer)player;
                            JSGSoundHelper.playSoundToPlayer(sp, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                            break;
                        }
                        case ENGAGED: {
                            player.m_5661_((Component)Component.m_237115_((String)"tile.jsg.dhd_block.incoming_wormhole_warn"), true);
                            if (!(player instanceof ServerPlayer)) break block0;
                            ServerPlayer sp = (ServerPlayer)player;
                            JSGSoundHelper.playSoundToPlayer(sp, SoundEventEnum.UNIVERSE_DIALER_ERROR, player.m_20183_());
                            break;
                        }
                        default: {
                            if (gateTile2.getStargateState() == EnumStargateState.DIALING && gateTile2.abortDialingSequence()) {
                                player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                                if (!(player instanceof ServerPlayer)) break block0;
                                ServerPlayer sp = (ServerPlayer)player;
                                JSGSoundHelper.playSoundToPlayer(sp, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                                break;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.gate_busy"), true);
                            break;
                        }
                    }
                    break;
                }
                case GATE_INFO: {
                    if (!(linkedTe instanceof StargateUniverseBaseBE)) break;
                    StargateUniverseBaseBE tile = (StargateUniverseBaseBE)linkedTe;
                    switch (tile.getStargateState()) {
                        case IDLE: {
                            break block0;
                        }
                        case ENGAGED_INITIATING: {
                            tile.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            break block0;
                        }
                        case ENGAGED: {
                            player.m_5661_((Component)Component.m_237115_((String)"tile.jsg.dhd_block.incoming_wormhole_warn"), true);
                            break block0;
                        }
                    }
                    if (tile.getStargateState() == EnumStargateState.DIALING && tile.abortDialingSequence()) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                        break;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.gate_busy"), true);
                    break;
                }
            }
        }
        return super.m_7203_(world, player, hand);
    }
}

