/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.util.EnumKeyInterface;
import dev.tauri.jsg.util.EnumKeyMap;
import dev.tauri.jsg.util.I18n;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public enum UniverseDialerMode implements EnumKeyInterface<Byte>
{
    NEARBY(0, "item.jsg.universe_dialer.mode_scan", true, "linkedGate", "nearby", BlockRegistry.STARGATE_UNIVERSE_BASE_BLOCK),
    MEMORY(1, "item.jsg.universe_dialer.mode_saved", true, "linkedGate", "saved", BlockRegistry.STARGATE_UNIVERSE_BASE_BLOCK),
    RINGS(2, "item.jsg.universe_dialer.mode_rings", true, "linkedRings", "rings", new RegistryObject[0]),
    OC(3, "item.jsg.universe_dialer.mode_oc", false, null, "ocmess", new RegistryObject[0]),
    GATE_INFO(4, "item.jsg.universe_dialer.mode_info", true, "linkedGate", "info", BlockRegistry.STARGATE_CLASSIC_BASE_BLOCKS),
    COUNTDOWN(5, "item.jsg.universe_dialer.mode_countdown", true, "linkedTimer", "timer", new RegistryObject[0]);

    public final byte id;
    public final String translationKey;
    public final boolean linkable;
    public final String tagPosName;
    public final String tagListName;
    public final RegistryObject<?>[] matchBlocks;
    private static final EnumKeyMap<Byte, UniverseDialerMode> ID_MAP;

    private UniverseDialerMode(int id, String translationKey, boolean linkable, String tagPosName, String tagListName, RegistryObject<?> ... matchBlocks) {
        this.id = (byte)id;
        this.translationKey = translationKey;
        this.linkable = linkable;
        this.tagPosName = tagPosName;
        this.tagListName = tagListName;
        this.matchBlocks = matchBlocks;
    }

    @Nonnull
    public UniverseDialerMode next() {
        return switch (this) {
            case NEARBY -> MEMORY;
            case MEMORY -> GATE_INFO;
            default -> NEARBY;
        };
    }

    @Nonnull
    public UniverseDialerMode prev() {
        return switch (this) {
            case NEARBY -> GATE_INFO;
            case GATE_INFO -> MEMORY;
            default -> NEARBY;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public String localize() {
        return I18n.format(this.translationKey);
    }

    public static UniverseDialerMode valueOf(byte id) {
        return ID_MAP.valueOf(id);
    }

    @Override
    public Byte getKey() {
        return this.id;
    }

    static {
        ID_MAP = new EnumKeyMap((EnumKeyInterface[])UniverseDialerMode.values());
    }
}

