/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.notebook;

import dev.tauri.jsg.item.JSGItem;
import dev.tauri.jsg.item.notebook.NotebookItemBEWLR;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class NotebookItem
extends JSGItem {
    public NotebookItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON), TabRegistry.TAB_TOOLS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final NotebookItemBEWLR instance = new NotebookItemBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41784_();
            ListTag list = compound.m_128437_("addressList", 10);
            for (Tag item : list) {
                CompoundTag pageTag = (CompoundTag)item;
                components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + PageNotebookItemFilled.getNameFromCompound(pageTag))));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        int newSelected;
        if (oldStack.m_41720_() != newStack.m_41720_()) {
            return true;
        }
        if (!oldStack.m_41782_() || !newStack.m_41782_()) {
            return true;
        }
        int oldSelected = oldStack.m_41784_().m_128451_("selected");
        return oldSelected != (newSelected = newStack.m_41784_().m_128451_("selected"));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack page;
        if (!world.f_46443_ && player.m_6144_() && !(page = NotebookItem.popCurrentPage(player.m_21120_(hand))).m_41619_()) {
            player.m_36356_(page);
        }
        return super.m_7203_(world, player, hand);
    }

    public static CompoundTag getSelectedPageFromCompound(CompoundTag compound) {
        int selected = compound.m_128451_("selected");
        ListTag list = compound.m_128437_("addressList", 10);
        return list.m_128728_(selected);
    }

    public static void setNameForIndex(ListTag list, int index, String name) {
        CompoundTag page = list.m_128728_(index);
        PageNotebookItemFilled.setName(page, name);
    }

    public static ItemStack createNotebook(@Nonnull ListTag pages) {
        ItemStack output = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_ITEM.get(), 1);
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("addressList", (Tag)pages);
        compound.m_128405_("selected", 0);
        output.m_41751_(compound);
        return output;
    }

    @Nonnull
    public static ItemStack popCurrentPage(ItemStack notebook) {
        CompoundTag tag = notebook.m_41784_();
        int index = tag.m_128451_("selected");
        return NotebookItem.popPage(notebook, index);
    }

    @Nonnull
    public static ItemStack popPage(ItemStack notebook, int index) {
        try {
            CompoundTag tag = notebook.m_41784_();
            ListTag list = tag.m_128437_("addressList", 10);
            CompoundTag pageNBT = (CompoundTag)list.get(index);
            ItemStack page = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get());
            page.m_41751_(pageNBT);
            list.remove(index);
            tag.m_128365_("addressList", (Tag)list);
            int currentIndex = tag.m_128451_("selected");
            if (currentIndex >= list.size()) {
                currentIndex = list.size() - 1;
                tag.m_128405_("selected", currentIndex);
            }
            notebook.m_41751_(tag);
            if (list.isEmpty() || currentIndex < 0) {
                notebook.m_41764_(0);
            }
            return page;
        }
        catch (IndexOutOfBoundsException ignored) {
            notebook.m_41764_(0);
            return ItemStack.f_41583_;
        }
    }
}

