/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.ModList;

public class FolderLoader {
    public static List<String> getAllFiles(Class<?> clazz, String modId, String path, String ... suffixes) throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        AtomicReference jarFile = new AtomicReference();
        ModList.get().getModContainerById(modId).ifPresentOrElse(container -> jarFile.set(container.getModInfo().getOwningFile().getFile().getFilePath().toFile()), () -> {});
        if (jarFile.get() == null) {
            return out;
        }
        String classPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        int separatorIndex = classPath.lastIndexOf("!");
        if (separatorIndex != -1) {
            JarFile jar = new JarFile((File)jarFile.get());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || !FolderLoader.endsWith(name, suffixes)) continue;
                out.add(name);
            }
            jar.close();
        } else {
            FolderLoader.getAllFilesDev(clazz, path, out, suffixes);
        }
        return out;
    }

    private static boolean endsWith(String in, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!in.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static void getAllFilesDev(Class<?> clazz, String path, List<String> out, String ... suffixes) throws IOException {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(stream)));
        while (reader.ready()) {
            String name = path + "/" + reader.readLine();
            if (FolderLoader.endsWith(name, suffixes)) {
                out.add(name);
                continue;
            }
            FolderLoader.getAllFilesDev(clazz, name, out, suffixes);
        }
        reader.close();
    }
}

