/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.model;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.loader.FolderLoader;
import dev.tauri.jsg.loader.OriginsLoader;
import dev.tauri.jsg.loader.model.OBJLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;

public class ModelLoader {
    private final String modId;
    private final Class<?> modMainClass;
    public final String modelsPath;
    private final Map<ResourceLocation, OBJModel> LOADED_MODELS = new HashMap<ResourceLocation, OBJModel>();
    public static final ModelLoader INSTANCE = new ModelLoader("jsg", JSG.class);
    public static final OBJModel EMPTY_MODEL = new OBJModel(new float[0], new float[0], new float[0], new int[0]);

    public ModelLoader(String modId, Class<?> modMainClass) {
        this.modId = modId;
        this.modMainClass = modMainClass;
        this.modelsPath = "assets/" + modId + "/models/tesr";
        JSG.logger.info("Created ModelLoader for domain " + modId);
    }

    public OBJModel getModel(ResourceLocation resourceLocation) {
        OBJModel model = this.LOADED_MODELS.get(resourceLocation);
        if (model == null) {
            return EMPTY_MODEL;
        }
        return model;
    }

    public void loadModels() {
        AtomicReference<String> modName = new AtomicReference<String>("");
        ModList.get().getModContainerById(this.modId).ifPresentOrElse(container -> modName.set(container.getModInfo().getDisplayName()), () -> {});
        try {
            this.LOADED_MODELS.clear();
            List<String> modelPaths = FolderLoader.getAllFiles(this.modMainClass, this.modId, this.modelsPath, ".obj");
            long start = System.currentTimeMillis();
            ProgressMeter progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Loading Models"), (int)modelPaths.size());
            JSG.logger.info("Started loading models for domain " + this.modId + "...");
            for (String modelPath : modelPaths) {
                if (((Boolean)JSGConfig.Debug.logLoadingTextures.get()).booleanValue()) {
                    JSG.logger.info("Loading model: " + modelPath + " for domain " + this.modId);
                }
                String modelResourcePath = modelPath.replaceFirst("assets/" + this.modId + "/", "");
                this.LOADED_MODELS.put(new ResourceLocation(this.modId, modelResourcePath), OBJLoader.loadModel(modelPath, this.modMainClass));
                ++JSG.ClientModEvents.LoadingStats.loadedModels;
                if (((Boolean)JSGConfig.Debug.logLoadingTextures.get()).booleanValue()) {
                    JSG.logger.info("Model " + modelPath + " for domain " + this.modId + " loaded!");
                }
                progress.increment();
                StartupNotificationManager.addModMessage((String)("Loaded " + modelResourcePath));
            }
            if (this.modId.equalsIgnoreCase("jsg")) {
                OriginsLoader.loadModels(this.LOADED_MODELS);
            }
            progress.complete();
            JSG.logger.info("Loaded " + modelPaths.size() + " models for domain " + this.modId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            JSG.logger.error("Error while loading models for mod " + this.modMainClass.toString());
            ++JSG.ClientModEvents.LoadingStats.notLoadedModels;
            e.printStackTrace();
        }
    }

    public ResourceLocation getModelResource(String model) {
        return new ResourceLocation(this.modId, "models/tesr/" + model);
    }
}

