/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.model;

import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.util.vectors.Vector2f;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;

public class OBJLoader {
    public static OBJModel loadModel(String modelPath, Class<?> clazz) {
        return OBJLoader.loadModel(Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(modelPath)));
    }

    public static OBJModel loadModel(InputStream stream) {
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        ArrayList<Vector2f> textures = new ArrayList<Vector2f>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        LinkedHashMap<Vertex, Integer> vertexIndexMap = new LinkedHashMap<Vertex, Integer>();
        int current = 0;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                String[] face;
                if (line.startsWith("v ")) {
                    vertices.add(OBJLoader.splitToVector(line));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    textures.add(OBJLoader.splitToVector2(line));
                    continue;
                }
                if (line.startsWith("vn ")) {
                    normals.add(OBJLoader.splitToVector(line));
                    continue;
                }
                if (!line.startsWith("f ")) continue;
                for (String verticle : face = line.split(" ")) {
                    if (verticle.equals("f")) continue;
                    String[] vtn = verticle.split("/");
                    Vertex vertex = new Vertex(vtn);
                    Integer index = (Integer)vertexIndexMap.get(vertex);
                    if (index != null) {
                        indices.add(index);
                        continue;
                    }
                    vertexIndexMap.put(vertex, current);
                    indices.add(current);
                    ++current;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean hasTex = !textures.isEmpty();
        int size = vertexIndexMap.size();
        int index = 0;
        float[] v = new float[size * 3];
        float[] t = new float[size * 2];
        float[] n = new float[size * 3];
        for (Vertex key : vertexIndexMap.keySet()) {
            Vector3f ver = (Vector3f)vertices.get(key.vId);
            Vector3f norm = (Vector3f)normals.get(key.nId);
            v[index * 3] = ver.getX();
            v[index * 3 + 1] = ver.getY();
            v[index * 3 + 2] = ver.getZ();
            n[index * 3] = norm.getX();
            n[index * 3 + 1] = norm.getY();
            n[index * 3 + 2] = norm.getZ();
            if (hasTex) {
                Vector2f tex = (Vector2f)textures.get(key.tId);
                t[index * 2] = tex.x;
                t[index * 2 + 1] = -tex.y;
            }
            ++index;
        }
        int[] ind = new int[indices.size()];
        for (int k = 0; k < indices.size(); ++k) {
            ind[k] = (Integer)indices.get(k);
        }
        return new OBJModel(v, t, n, ind);
    }

    private static Vector3f splitToVector(String line) {
        String[] splitted = line.split(" ");
        float x = Float.parseFloat(splitted[1]);
        float y = Float.parseFloat(splitted[2]);
        float z = Float.parseFloat(splitted[3]);
        return new Vector3f(x, y, z);
    }

    private static Vector2f splitToVector2(String line) {
        String[] splitted = line.split(" ");
        float x = Float.parseFloat(splitted[1]);
        float y = Float.parseFloat(splitted[2]);
        return new Vector2f(x, y);
    }

    private static class Vertex {
        int vId;
        int tId;
        int nId;

        public Vertex(String[] vtn) {
            if (vtn.length == 3) {
                this.vId = Integer.parseInt(vtn[0]) - 1;
                if (!vtn[1].isEmpty()) {
                    this.tId = Integer.parseInt(vtn[1]) - 1;
                }
                if (!vtn[2].isEmpty()) {
                    this.nId = Integer.parseInt(vtn[2]) - 1;
                }
            }
        }

        public String toString() {
            return this.vId + "/" + this.tId + "/" + this.nId;
        }
    }
}

