/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL46C;

public class OBJModel {
    public float[] vertices;
    public float[] textureCoords;
    public float[] normals;
    public int[] indices;
    public VertexBuffer bufferedModelGUI = null;
    public static MultiBufferSource source;
    private static float[] rgb;
    private static float light;
    public static int packedLight;
    public static EnumOBJRenderMethod renderType;
    private final Map<Integer, VertexBuffer> inGameBuffers = new HashMap<Integer, VertexBuffer>();

    public OBJModel(float[] vertices, float[] textureCoords, float[] normals, int[] indices) {
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.indices = indices;
    }

    public static void setDynamicLightning(float l) {
        light = l;
    }

    public static void setRGB(float r, float g, float b, float a) {
        rgb = new float[]{r, g, b, a};
    }

    public static void resetDynamicLightning() {
        light = 1.0f;
    }

    public static void resetRGB() {
        OBJModel.setRGB(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack stack) {
        this.render(stack, false);
    }

    public void render(PoseStack stack, boolean renderEmissive) {
        this.render(stack, renderEmissive, null);
    }

    public void render(PoseStack stack, boolean renderEmissive, @Nullable Supplier<ShaderInstance> shaderOverride) {
        if (this.vertices.length < 1) {
            return;
        }
        if (renderType == EnumOBJRenderMethod.ADMIN_CONTROLLER) {
            this.renderLegacy(stack);
            return;
        }
        if (renderType == EnumOBJRenderMethod.GUI) {
            if (this.bufferedModelGUI == null) {
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                this.bufferedModelGUI = new VertexBuffer(VertexBuffer.Usage.STATIC);
                this.initGUIModel(bufferbuilder);
            }
            EmissiveRenderer.renderWithLightOverlay(stack, false, () -> {
                GL46C.glEnable((int)34383);
                RenderSystem.setShaderColor((float)(light * rgb[0]), (float)(light * rgb[1]), (float)(light * rgb[2]), (float)rgb[3]);
                this.bufferedModelGUI.m_85921_();
            }, () -> {
                Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)((double)Minecraft.m_91087_().m_91268_().m_85441_() / Minecraft.m_91087_().m_91268_().m_85449_()), (float)((double)Minecraft.m_91087_().m_91268_().m_85442_() / Minecraft.m_91087_().m_91268_().m_85449_()), 0.0f, -1000.0f, ForgeHooksClient.getGuiFarPlane());
                this.bufferedModelGUI.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, Objects.requireNonNull(RenderSystem.getShader()));
                VertexBuffer.m_85931_();
                GL46C.glDisable((int)34383);
            }, shaderOverride != null ? shaderOverride : GameRenderer::m_172817_);
            return;
        }
        VertexBuffer bufferedModelInGame = this.getModelBufferIngame();
        EmissiveRenderer.renderWithLightOverlay(stack, renderEmissive, () -> {
            RenderSystem.setShaderColor((float)(light * rgb[0]), (float)(light * rgb[1]), (float)(light * rgb[2]), (float)rgb[3]);
            bufferedModelInGame.m_85921_();
        }, () -> {
            Matrix4f projection = RenderSystem.getProjectionMatrix();
            Matrix4f matrix = new Matrix4f((Matrix4fc)stack.m_85850_().m_252922_());
            bufferedModelInGame.m_253207_(matrix, projection, Objects.requireNonNull(RenderSystem.getShader()));
            VertexBuffer.m_85931_();
        }, shaderOverride);
    }

    @Nonnull
    private VertexBuffer getModelBufferIngame() {
        VertexBuffer buffer = this.inGameBuffers.get(packedLight);
        if (buffer != null) {
            return buffer;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        buffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        this.initGameModel(bufferbuilder, buffer);
        this.inGameBuffers.put(packedLight, buffer);
        return buffer;
    }

    private void initGameModel(BufferBuilder bufferbuilder, @Nonnull VertexBuffer buffer) {
        if (!bufferbuilder.m_85732_()) {
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        }
        int vertexCount = this.vertices.length;
        for (int i = 0; i < vertexCount; i += 9) {
            Vector3f normal1 = new Vector3f(this.normals[i], this.normals[i + 1], this.normals[i + 2]).normalize();
            Vector3f normal2 = new Vector3f(this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]).normalize();
            Vector3f normal3 = new Vector3f(this.normals[i + 6], this.normals[i + 7], this.normals[i + 8]).normalize();
            bufferbuilder.m_5483_((double)this.vertices[i], (double)this.vertices[i + 1], (double)this.vertices[i + 2]).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(this.textureCoords[i / 3 * 2], this.textureCoords[i / 3 * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal1.x(), normal1.y(), normal1.z()).m_5752_();
            bufferbuilder.m_5483_((double)this.vertices[i + 3], (double)this.vertices[i + 4], (double)this.vertices[i + 5]).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(this.textureCoords[i / 3 * 2 + 2], this.textureCoords[i / 3 * 2 + 3]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal2.x(), normal2.y(), normal2.z()).m_5752_();
            bufferbuilder.m_5483_((double)this.vertices[i + 6], (double)this.vertices[i + 7], (double)this.vertices[i + 8]).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(this.textureCoords[i / 3 * 2 + 4], this.textureCoords[i / 3 * 2 + 5]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal3.x(), normal3.y(), normal3.z()).m_5752_();
        }
        BufferBuilder.RenderedBuffer rb = bufferbuilder.m_231175_();
        buffer.m_85921_();
        buffer.m_231221_(rb);
        VertexBuffer.m_85931_();
    }

    private void initGUIModel(BufferBuilder bufferbuilder) {
        if (!bufferbuilder.m_85732_()) {
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        }
        int vertexCount = this.vertices.length;
        for (int i = 0; i < vertexCount; i += 9) {
            bufferbuilder.m_5483_((double)this.vertices[i], (double)this.vertices[i + 1], (double)this.vertices[i + 2]).m_7421_(this.textureCoords[i / 3 * 2], this.textureCoords[i / 3 * 2 + 1]).m_5752_();
            bufferbuilder.m_5483_((double)this.vertices[i + 3], (double)this.vertices[i + 4], (double)this.vertices[i + 5]).m_7421_(this.textureCoords[i / 3 * 2 + 2], this.textureCoords[i / 3 * 2 + 3]).m_5752_();
            bufferbuilder.m_5483_((double)this.vertices[i + 6], (double)this.vertices[i + 7], (double)this.vertices[i + 8]).m_7421_(this.textureCoords[i / 3 * 2 + 4], this.textureCoords[i / 3 * 2 + 5]).m_5752_();
        }
        BufferBuilder.RenderedBuffer rb = bufferbuilder.m_231175_();
        this.bufferedModelGUI.m_85921_();
        this.bufferedModelGUI.m_231221_(rb);
        VertexBuffer.m_85931_();
    }

    public void renderLegacy(PoseStack stack) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f matrix = stack.m_85850_().m_252922_();
        EmissiveRenderer.renderWithLightOverlay(stack, false, () -> {
            RenderSystem.setShaderColor((float)(light * rgb[0]), (float)(light * rgb[1]), (float)(light * rgb[2]), (float)rgb[3]);
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
            int vertexCount = this.vertices.length;
            int vertexOffset = 0;
            int texCoordOffset = 0;
            for (int i = 0; i < vertexCount / 9; ++i) {
                float x1 = this.vertices[vertexOffset];
                float y1 = this.vertices[vertexOffset + 1];
                float z1 = this.vertices[vertexOffset + 2];
                float x2 = this.vertices[vertexOffset + 3];
                float y2 = this.vertices[vertexOffset + 4];
                float z2 = this.vertices[vertexOffset + 5];
                float x3 = this.vertices[vertexOffset + 6];
                float y3 = this.vertices[vertexOffset + 7];
                float z3 = this.vertices[vertexOffset + 8];
                float texU1 = this.textureCoords[texCoordOffset];
                float texV1 = this.textureCoords[texCoordOffset + 1];
                float texU2 = this.textureCoords[texCoordOffset + 2];
                float texV2 = this.textureCoords[texCoordOffset + 3];
                float texU3 = this.textureCoords[texCoordOffset + 4];
                float texV3 = this.textureCoords[texCoordOffset + 5];
                bufferbuilder.m_252986_(matrix, x1, y1, z1).m_7421_(texU1, texV1).m_5752_();
                bufferbuilder.m_252986_(matrix, x2, y2, z2).m_7421_(texU2, texV2).m_5752_();
                bufferbuilder.m_252986_(matrix, x3, y3, z3).m_7421_(texU3, texV3).m_5752_();
                vertexOffset += 9;
                texCoordOffset += 6;
            }
        }, () -> {
            tesselator.m_85914_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }, GameRenderer::m_172817_);
    }

    static {
        rgb = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        light = 1.0f;
        packedLight = 0xF000F0;
        renderType = EnumOBJRenderMethod.NORMAL;
    }

    public static enum EnumOBJRenderMethod {
        NORMAL,
        GUI,
        ADMIN_CONTROLLER;

    }
}

