/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.texture;

import com.mojang.blaze3d.platform.NativeImage;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.loader.FolderLoader;
import dev.tauri.jsg.loader.OriginsLoader;
import dev.tauri.jsg.loader.texture.Texture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;

public class TextureLoader {
    private final String modId;
    private final Class<?> modMainClass;
    public final String texturesPath;
    private final Map<ResourceLocation, Texture> LOADED_TEXTURES = new HashMap<ResourceLocation, Texture>();
    public static final TextureLoader INSTANCE = new TextureLoader("jsg", JSG.class);

    public TextureLoader(String modId, Class<?> modMainClass) {
        this.modId = modId;
        this.modMainClass = modMainClass;
        this.texturesPath = "assets/" + modId + "/textures/tesr";
        JSG.logger.info("Created TextureLoader for domain " + modId);
    }

    public Texture getTexture(ResourceLocation resourceLocation) {
        Texture tex = this.LOADED_TEXTURES.get(resourceLocation);
        if (tex == null) {
            return Texture.getEmptyTexture();
        }
        return tex;
    }

    public boolean isTextureLoaded(ResourceLocation resourceLocation) {
        return this.LOADED_TEXTURES.containsKey(resourceLocation);
    }

    public void loadTextures() {
        AtomicReference<String> modName = new AtomicReference<String>("");
        ModList.get().getModContainerById(this.modId).ifPresentOrElse(container -> modName.set(container.getModInfo().getDisplayName()), () -> {});
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            for (Texture texture : this.LOADED_TEXTURES.values()) {
                texture.deleteTexture();
            }
            this.LOADED_TEXTURES.clear();
            if (this.modId.equalsIgnoreCase("jsg")) {
                OriginsLoader.registerTextures(this.LOADED_TEXTURES);
            }
            ArrayList<String> texturePaths = new ArrayList<String>();
            ArrayList<String> ehPaths = new ArrayList<String>();
            block12: for (String texturePath : FolderLoader.getAllFiles(this.modMainClass, this.modId, this.texturesPath, ".png", ".jpg")) {
                switch (texturePath = texturePath.replaceFirst("assets/jsg/", "")) {
                    case "textures/tesr/event_horizon_animated_unstable.jpg": 
                    case "textures/tesr/event_horizon_animated.jpg": 
                    case "textures/tesr/event_horizon_animated_kawoosh.jpg": 
                    case "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg": {
                        ehPaths.add(texturePath);
                        continue block12;
                    }
                }
                texturePaths.add(texturePath);
            }
            long start = System.currentTimeMillis();
            ProgressMeter progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Loading Textures"), (int)texturePaths.size());
            JSG.logger.info("Started loading textures for domain " + this.modId + "...");
            for (String texturePath : texturePaths) {
                this.loadTexture(progress, texturePath, resourceManager);
            }
            progress.complete();
            JSG.logger.info("Loaded " + texturePaths.size() + " textures for domain " + this.modId + " in " + (System.currentTimeMillis() - start) + " ms");
            start = System.currentTimeMillis();
            progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - Animated Textures"), (int)ehPaths.size());
            JSG.logger.info("Started loading animated textures for domain " + this.modId + "...");
            for (String texturePath : ehPaths) {
                this.loadTexture(progress, texturePath, resourceManager);
            }
            progress.complete();
            JSG.logger.info("Loaded " + ehPaths.size() + " animated textures for domain " + this.modId + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            JSG.logger.error("Failed to load texture ", (Throwable)e);
        }
    }

    public void loadTexture(ProgressMeter progress, String texturePath, ResourceManager resourceManager) {
        texturePath = texturePath.replaceFirst("assets/" + this.modId + "/", "");
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, texturePath);
        try {
            if (((Boolean)JSGConfig.Debug.logLoadingTextures.get()).booleanValue()) {
                JSG.logger.info("Loading texture: " + texturePath + " for domain " + this.modId);
            }
            Resource resource = (Resource)resourceManager.m_213713_(resourceLocation).orElseThrow();
            InputStream stream = resource.m_215507_();
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            this.LOADED_TEXTURES.put(resourceLocation, new Texture(image, resourceLocation));
            ++JSG.ClientModEvents.LoadingStats.loadedTextures;
            if (((Boolean)JSGConfig.Debug.logLoadingTextures.get()).booleanValue()) {
                JSG.logger.info("Texture " + texturePath + " for domain " + this.modId + " loaded!");
            }
            progress.increment();
            StartupNotificationManager.addModMessage((String)("Loaded " + texturePath));
        }
        catch (IOException e) {
            ++JSG.ClientModEvents.LoadingStats.notLoadedTextures;
            JSG.logger.error("Failed to load texture " + texturePath, (Throwable)e);
        }
    }

    public ResourceLocation getTextureResource(String texture) {
        return new ResourceLocation(this.modId, "textures/tesr/" + texture);
    }
}

