/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import dev.tauri.jsg.model.JSGBakedModelWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGBlockModel
extends BlockModel
implements IUnbakedGeometry<JSGBlockModel> {
    public final List<ItemDisplayContext> customRenderTypes;

    public JSGBlockModel(List<ItemDisplayContext> customRenderTypes, @Nullable ResourceLocation pParentLocation, List<BlockElement> pElements, Map<String, Either<Material, String>> pTextureMap, @Nullable Boolean pHasAmbientOcclusion, @Nullable BlockModel.GuiLight pGuiLight, ItemTransforms pTransforms, List<ItemOverride> pOverrides) {
        super(pParentLocation, pElements, pTextureMap, pHasAmbientOcclusion, pGuiLight, pTransforms, pOverrides);
        this.customRenderTypes = customRenderTypes;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return this.m_111449_(baker, this, spriteGetter, modelState, modelLocation, true);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BakedModel m_111449_(ModelBaker pBaker, BlockModel pModel, Function<Material, TextureAtlasSprite> pSpriteGetter, ModelState pState, ResourceLocation pLocation, boolean pGuiLight3d) {
        return new JSGBakedModelWrapper(super.m_111449_(pBaker, pModel, pSpriteGetter, pState, pLocation, pGuiLight3d), this.customRenderTypes);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.m_5500_(modelGetter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Loader
    implements IGeometryLoader<JSGBlockModel> {
        public static final Loader INSTANCE = new Loader();

        public JSGBlockModel read(JsonObject pJson, JsonDeserializationContext pContext) {
            JsonObject jsonobject = pJson.getAsJsonObject();
            List<BlockElement> list = this.getElements(pContext, jsonobject);
            String s = this.getParentName(jsonobject);
            Map<String, Either<Material, String>> map = this.getTextureMap(jsonobject);
            Boolean obool = this.getAmbientOcclusion(jsonobject);
            ItemTransforms itemtransforms = ItemTransforms.f_111786_;
            if (jsonobject.has("display")) {
                JsonObject display = GsonHelper.m_13930_((JsonObject)jsonobject, (String)"display");
                itemtransforms = (ItemTransforms)pContext.deserialize((JsonElement)display, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.getOverrides(pContext, jsonobject);
            BlockModel.GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = BlockModel.GuiLight.m_111527_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            ArrayList<ItemDisplayContext> customRenderTypes = new ArrayList<ItemDisplayContext>();
            if (jsonobject.has("custom_render_types")) {
                JsonArray renderTypes = jsonobject.getAsJsonArray("custom_render_types");
                for (JsonElement rt : renderTypes) {
                    customRenderTypes.add(ItemDisplayContext.valueOf((String)rt.getAsString()));
                }
            }
            return new JSGBlockModel(customRenderTypes, resourcelocation, list, map, obool, blockmodel$guilight, itemtransforms, list1);
        }

        private List<ItemOverride> getOverrides(JsonDeserializationContext pContext, JsonObject pJson) {
            ArrayList list = Lists.newArrayList();
            if (pJson.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)pJson, (String)"overrides")) {
                    list.add((ItemOverride)pContext.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<Material, String>> getTextureMap(JsonObject pJson) {
            ResourceLocation resourcelocation = InventoryMenu.f_39692_;
            HashMap map = Maps.newHashMap();
            if (pJson.has("textures")) {
                JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)pJson, (String)"textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Loader.parseTextureLocationOrReference(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<Material, String> parseTextureLocationOrReference(ResourceLocation pLocation, String pName) {
            if (pName.charAt(0) == '#') {
                return Either.right((Object)pName.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)pName);
            if (resourcelocation == null) {
                throw new JsonParseException(pName + " is not valid resource location");
            }
            return Either.left((Object)new Material(pLocation, resourcelocation));
        }

        private String getParentName(JsonObject pJson) {
            return GsonHelper.m_13851_((JsonObject)pJson, (String)"parent", (String)"");
        }

        @Nullable
        private Boolean getAmbientOcclusion(JsonObject pJson) {
            return pJson.has("ambientocclusion") ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)pJson, (String)"ambientocclusion")) : null;
        }

        private List<BlockElement> getElements(JsonDeserializationContext pContext, JsonObject pJson) {
            ArrayList list = Lists.newArrayList();
            if (pJson.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)pJson, (String)"elements")) {
                    list.add((BlockElement)pContext.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }
    }
}

