/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.packet.packets.AdminControllerGuiOpenHandler;
import dev.tauri.jsg.screen.gui.admincontroller.GuiAdminController;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class AdminControllerGuiOpenToClient
extends PositionedPacket {
    protected StargateNetwork network;
    protected boolean displayGui;

    public AdminControllerGuiOpenToClient() {
    }

    public AdminControllerGuiOpenToClient(BlockPos pos, StargateNetwork network) {
        super(pos);
        this.network = network;
        this.displayGui = true;
    }

    public AdminControllerGuiOpenToClient(BlockPos pos, StargateNetwork network, boolean displayGui) {
        super(pos);
        this.network = network;
        this.displayGui = displayGui;
    }

    public AdminControllerGuiOpenToClient(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        if (this.network != null) {
            buf.writeBoolean(true);
            this.network.toBytes((ByteBuf)buf);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.displayGui);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.network = new StargateNetwork();
            this.network.fromBytes((ByteBuf)buf);
        }
        this.displayGui = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (this.displayGui) {
                AdminControllerGuiOpenHandler.openGui(this.pos, this.network);
            } else if (GuiAdminController.currentInstance != null) {
                GuiAdminController.currentInstance.stargateNetwork = this.network;
            }
        });
    }
}

