/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.effect;

import dev.tauri.jsg.effect.StargateWormholeEffect;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.packet.JSGPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class StargateWormholeEffectToClient
extends JSGPacket {
    private int stop;
    private int length;
    private StargateWormholeType type;

    public StargateWormholeEffectToClient() {
    }

    public StargateWormholeEffectToClient(boolean stop, StargateWormholeType type, int length) {
        this.stop = stop ? 10 : 5;
        this.type = type;
        this.length = length;
    }

    public StargateWormholeEffectToClient(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.stop);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.length);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.stop = buf.readInt();
        this.type = StargateWormholeType.values()[buf.readInt()];
        this.length = buf.readInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.enqueueWork(() -> {
            ctx.setPacketHandled(true);
            if (this.stop == 10) {
                StargateWormholeEffect.stop();
            } else if (this.stop == 5) {
                StargateWormholeEffect.play(this.type, this.length + 20);
            }
        });
    }
}

