/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.linkable;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.item.linkable.gdo.GDOItem;
import dev.tauri.jsg.packet.JSGPacket;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.codesender.PlayerCodeSender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class GDOCodeKeyPressedToServer
extends JSGPacket {
    int number;
    InteractionHand hand;

    public GDOCodeKeyPressedToServer(InteractionHand hand, int number) {
        this.hand = hand;
        this.number = number;
    }

    public GDOCodeKeyPressedToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.number);
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.number = buf.readInt();
        this.hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = player.m_21120_(this.hand);
            if (stack.m_41720_() != ItemRegistry.GDO.get()) {
                return;
            }
            if (!stack.m_41782_()) {
                return;
            }
            CompoundTag compound = stack.m_41784_();
            Object code = compound.m_128461_("entered_code");
            if (this.number >= 0 && this.number <= 9) {
                if (((String)(code = (String)code + String.valueOf(this.number))).length() > (Integer)JSGConfig.Stargate.irisCodeLength.get()) {
                    return;
                }
                compound.m_128359_("entered_code", (String)code);
                stack.m_41751_(compound);
                JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.GDO_BUTTON_CLICK, player.m_20183_());
                return;
            }
            if (this.number == -1 && !((String)code).isEmpty()) {
                JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.GDO_BUTTON_CLICK, player.m_20183_());
                if (((GDOItem)ItemRegistry.GDO.get()).sendCode(stack, new PlayerCodeSender((Player)player))) {
                    JSGAdvancements.GDO_USED.trigger(player);
                }
                compound.m_128359_("entered_code", "");
                stack.m_41751_(compound);
            }
            if (this.number == -2 && !((String)code).isEmpty()) {
                JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.GDO_BUTTON_CLICK, player.m_20183_());
                compound.m_128359_("entered_code", ((String)code).substring(0, ((String)code).length() - 1));
                stack.m_41751_(compound);
            }
        });
    }
}

