/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.power.general;

import dev.tauri.jsg.power.general.SmallEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.energy.IEnergyStorage;

public class LargeEnergyStorage
extends SmallEnergyStorage {
    private final List<IEnergyStorage> storages = new ArrayList<IEnergyStorage>();

    public void clearStorages() {
        this.storages.clear();
    }

    public void addStorage(IEnergyStorage storage) {
        this.storages.add(storage);
    }

    public int getEnergyStored() {
        int energyStored = this.energy;
        for (IEnergyStorage storage : this.storages) {
            energyStored += storage.getEnergyStored();
        }
        return energyStored;
    }

    public int getMaxEnergyStored() {
        int maxEnergyStored = this.capacity;
        for (IEnergyStorage storage : this.storages) {
            maxEnergyStored += storage.getMaxEnergyStored();
        }
        return maxEnergyStored;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int toReceive = maxReceive;
        toReceive -= super.receiveEnergy(maxReceive, simulate);
        for (IEnergyStorage storage : this.storages) {
            if (toReceive == 0) {
                return maxReceive;
            }
            toReceive -= storage.receiveEnergy(toReceive, simulate);
        }
        if (!simulate) {
            this.onEnergyChanged();
        }
        return maxReceive - toReceive;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int toExtract = maxExtract;
        for (IEnergyStorage storage : this.storages) {
            if (toExtract == 0) {
                return maxExtract;
            }
            toExtract -= storage.extractEnergy(toExtract, simulate);
        }
        toExtract -= super.extractEnergy(toExtract, simulate);
        if (!simulate) {
            this.onEnergyChanged();
        }
        return maxExtract - toExtract;
    }

    public void setEnergyStoredInternally(int energy) {
        this.energy = energy;
    }

    public int getEnergyStoredInternally() {
        return this.energy;
    }

    public int getMaxEnergyStoredInternally() {
        return this.capacity;
    }
}

