/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.raycaster.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class RayCastedButton {
    public List<Vector3f> vectors;
    public int buttonId;

    public RayCastedButton(int buttonId, List<Vector3f> vectors) {
        this(buttonId, vectors, false);
    }

    public RayCastedButton(int buttonId, List<Vector3f> vectors, boolean correctXYZ) {
        this.buttonId = buttonId;
        this.vectors = vectors;
        if (correctXYZ) {
            this.vectors = new ArrayList<Vector3f>();
            for (Vector3f v : vectors) {
                this.vectors.add(new Vector3f(v.getX(), -v.getZ(), v.getY()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack stack) {
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder b = t.m_85915_();
        b.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (Vector3f vertex : this.vectors) {
            b.m_252986_(matrix, vertex.x, vertex.z, -vertex.y).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        }
        b.m_252986_(matrix, this.vectors.get((int)0).x, this.vectors.get((int)0).z, -this.vectors.get((int)0).y).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        t.m_85914_();
        stack.m_85849_();
    }
}

