/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.recipes;

import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.registry.ItemRegistry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NotebookRecipe
extends ShapelessRecipe {
    public NotebookRecipe() {
        super(new ResourceLocation("jsg", "notebook_creation"), "JSG", CraftingBookCategory.MISC, new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_ITEM.get()), NonNullList.m_122779_());
    }

    @ParametersAreNonnullByDefault
    public boolean m_5818_(CraftingContainer inv, Level pLevel) {
        int matchCount = 0;
        boolean hasNote = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get() || item == ItemRegistry.NOTEBOOK_ITEM.get() || item == Items.f_42517_) {
                ++matchCount;
                if (hasNote || item != ItemRegistry.NOTEBOOK_PAGE_FILLED.get()) continue;
                hasNote = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return hasNote && matchCount >= 2;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        int outputCount = 0;
        ListTag pages = new ListTag();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item == ItemRegistry.NOTEBOOK_ITEM.get()) {
                if (stack.m_41782_()) {
                    ListTag notebookTags = stack.m_41784_().m_128437_("addressList", 10);
                    for (Tag tag : notebookTags) {
                        if (NotebookRecipe.tagListContains(pages, (CompoundTag)tag)) continue;
                        pages.add((Object)tag);
                    }
                }
                ++outputCount;
                continue;
            }
            if (item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get()) {
                CompoundTag compound = stack.m_41783_();
                if (NotebookRecipe.tagListContains(pages, compound)) continue;
                pages.add((Object)compound);
                continue;
            }
            if (item != Items.f_42517_) continue;
            ++outputCount;
        }
        if (outputCount == 0) {
            outputCount = 1;
        }
        ItemStack output = NotebookItem.createNotebook(pages);
        output.m_41764_(outputCount);
        return output;
    }

    @ParametersAreNonnullByDefault
    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44077_;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static boolean tagListContains(ListTag tagList, CompoundTag compound) {
        if (compound == null) {
            return false;
        }
        for (Tag tag : tagList) {
            if (!tag.equals(compound)) continue;
            return true;
        }
        return false;
    }
}

