/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.registry;

import dev.tauri.jsg.block.IItemBlock;
import dev.tauri.jsg.block.PrinterBlock;
import dev.tauri.jsg.block.ToasterBlock;
import dev.tauri.jsg.block.capacitor.CapacitorBlock;
import dev.tauri.jsg.block.crystal.CrystalBudType;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.block.dialhomedevice.DHDMilkyWayBlock;
import dev.tauri.jsg.block.dialhomedevice.DHDPegasusBlock;
import dev.tauri.jsg.block.generator.OrbanNaquadahGeneratorBlock;
import dev.tauri.jsg.block.invisible.InvisibleBlock;
import dev.tauri.jsg.block.invisible.IrisBlock;
import dev.tauri.jsg.block.stargate.StargateMilkyWayBaseBlock;
import dev.tauri.jsg.block.stargate.StargateMilkyWayMemberBlock;
import dev.tauri.jsg.block.stargate.StargateMovieBaseBlock;
import dev.tauri.jsg.block.stargate.StargateMovieMemberBlock;
import dev.tauri.jsg.block.stargate.StargateOrlinBaseBlock;
import dev.tauri.jsg.block.stargate.StargateOrlinMemberBlock;
import dev.tauri.jsg.block.stargate.StargatePegasusBaseBlock;
import dev.tauri.jsg.block.stargate.StargatePegasusMemberBlock;
import dev.tauri.jsg.block.stargate.StargateTollanBaseBlock;
import dev.tauri.jsg.block.stargate.StargateTollanMemberBlock;
import dev.tauri.jsg.block.stargate.StargateUniverseBaseBlock;
import dev.tauri.jsg.block.stargate.StargateUniverseMemberBlock;
import dev.tauri.jsg.block.stargate.redstone.StargateRedstoneDialerI;
import dev.tauri.jsg.block.stargate.redstone.StargateRedstoneStateO;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.item.ITabbedItem;
import dev.tauri.jsg.item.JSGBlockItem;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.Map;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"jsg");
    public static final RegistryObject<Block> INVISIBLE_BLOCK = REGISTER.register("invisible_block", InvisibleBlock::new);
    public static final RegistryObject<Block> IRIS_BLOCK = REGISTER.register("iris_block", IrisBlock::new);
    public static final RegistryObject<Block> STARGATE_ORLIN_BASE_BLOCK = REGISTER.register("stargate_orlin_base_block", StargateOrlinBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_ORLIN_MEMBER_BLOCK = REGISTER.register("stargate_orlin_member_block", StargateOrlinMemberBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_BASE_BLOCK = REGISTER.register("stargate_milkyway_base_block", StargateMilkyWayBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_CHEVRON_BLOCK = REGISTER.register("stargate_milkyway_chevron_block", StargateMilkyWayMemberBlock.StargateMilkyWayChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_MILKYWAY_RING_BLOCK = REGISTER.register("stargate_milkyway_ring_block", StargateMilkyWayMemberBlock.StargateMilkyWayRingBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_BASE_BLOCK = REGISTER.register("stargate_pegasus_base_block", StargatePegasusBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_CHEVRON_BLOCK = REGISTER.register("stargate_pegasus_chevron_block", StargatePegasusMemberBlock.StargatePegasusChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_PEGASUS_RING_BLOCK = REGISTER.register("stargate_pegasus_ring_block", StargatePegasusMemberBlock.StargatePegasusRingBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_BASE_BLOCK = REGISTER.register("stargate_universe_base_block", StargateUniverseBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_CHEVRON_BLOCK = REGISTER.register("stargate_universe_chevron_block", StargateUniverseMemberBlock.StargateUniverseChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_UNIVERSE_RING_BLOCK = REGISTER.register("stargate_universe_ring_block", StargateUniverseMemberBlock.StargateUniverseRingBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_BASE_BLOCK = REGISTER.register("stargate_tollan_base_block", StargateTollanBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_CHEVRON_BLOCK = REGISTER.register("stargate_tollan_chevron_block", StargateTollanMemberBlock.StargateTollanChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_TOLLAN_RING_BLOCK = REGISTER.register("stargate_tollan_ring_block", StargateTollanMemberBlock.StargateTollanRingBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_BASE_BLOCK = REGISTER.register("stargate_movie_base_block", StargateMovieBaseBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_CHEVRON_BLOCK = REGISTER.register("stargate_movie_chevron_block", StargateMovieMemberBlock.StargateMovieChevronBlock::new);
    public static final RegistryObject<Block> STARGATE_MOVIE_RING_BLOCK = REGISTER.register("stargate_movie_ring_block", StargateMovieMemberBlock.StargateMovieRingBlock::new);
    public static final RegistryObject<Block> DHD_MILKYWAY = REGISTER.register("dhd_milkyway", DHDMilkyWayBlock::new);
    public static final RegistryObject<Block> DHD_PEGASUS = REGISTER.register("dhd_pegasus", DHDPegasusBlock::new);
    public static final RegistryObject<Block> CAPACITOR_BLOCK = REGISTER.register("capacitor_block", () -> new CapacitorBlock(false));
    public static final RegistryObject<Block> CAPACITOR_BLOCK_CREATIVE = REGISTER.register("capacitor_block_creative", () -> new CapacitorBlock(true));
    public static final RegistryObject<Block> ORBAN_NAQUADAH_GENERATOR_BLOCK = REGISTER.register("orban_naquadah_generator_block", OrbanNaquadahGeneratorBlock::new);
    public static final RegistryObject<Block> SG_REDSTONE_STATE_O_BLOCK = REGISTER.register("sg_redstone_state_output_block", StargateRedstoneStateO::new);
    public static final RegistryObject<Block> SG_REDSTONE_DIALER_I_BLOCK = REGISTER.register("sg_redstone_dialer_input_block", StargateRedstoneDialerI::new);
    public static final Map<BlockHelpers.OreBlockVariant, RegistryObject<Block>> ORE_NAQUADAH = BlockHelpers.createOreBlock("naquadah_ore");
    public static final Map<BlockHelpers.OreBlockVariant, RegistryObject<Block>> ORE_TITANIUM = BlockHelpers.createOreBlock("titanium_ore");
    public static final Map<BlockHelpers.OreBlockVariant, RegistryObject<Block>> ORE_TRINIUM = BlockHelpers.createOreBlock("trinium_ore");
    public static final RegistryObject<Block> NAQUADAH_RAW_BLOCK = BlockHelpers.createGenericBlock("naquadah_alloy_raw_block", TabRegistry.TAB_RESOURCES, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    public static final RegistryObject<Block> NAQUADAH_BLOCK = BlockHelpers.createGenericBlock("naquadah_alloy_block", TabRegistry.TAB_RESOURCES, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    public static final RegistryObject<Block> TITANIUM_BLOCK = BlockHelpers.createGenericBlock("titanium_block", TabRegistry.TAB_RESOURCES, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    public static final RegistryObject<Block> TRINIUM_BLOCK = BlockHelpers.createGenericBlock("trinium_block", TabRegistry.TAB_RESOURCES, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BLOCK = BlockHelpers.createCrystalBlock("{color}_crystal_block", BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154654_));
    public static final Map<BlockHelpers.OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> CRYSTAL_BUDDING = BlockHelpers.createCrystalBuddingBlock("budding_{color}_crystal");
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_SMALL = BlockHelpers.createCrystalBudBlock("small_{color}_crystal_bud", CrystalBudType.SMALL);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_MEDIUM = BlockHelpers.createCrystalBudBlock("medium_{color}_crystal_bud", CrystalBudType.MEDIUM);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_BUD_LARGE = BlockHelpers.createCrystalBudBlock("large_{color}_crystal_bud", CrystalBudType.LARGE);
    public static final Map<CrystalColor, RegistryObject<Block>> CRYSTAL_CLUSTER = BlockHelpers.createCrystalBudBlock("{color}_crystal_cluster", CrystalBudType.CLUSTER);
    public static final RegistryObject<Block> TOASTER = REGISTER.register("toaster", ToasterBlock::new);
    public static final RegistryObject<Block> PRINTER = REGISTER.register("printer", PrinterBlock::new);
    public static final RegistryObject<?>[] STARGATE_BASE_BLOCKS = new RegistryObject[]{STARGATE_MILKYWAY_BASE_BLOCK, STARGATE_PEGASUS_BASE_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_ORLIN_BASE_BLOCK, STARGATE_TOLLAN_BASE_BLOCK, STARGATE_MOVIE_BASE_BLOCK};
    public static final RegistryObject<?>[] STARGATE_MILKYWAY_BASE_BLOCKS = new RegistryObject[]{STARGATE_MILKYWAY_BASE_BLOCK, STARGATE_TOLLAN_BASE_BLOCK, STARGATE_MOVIE_BASE_BLOCK};
    public static final RegistryObject<?>[] STARGATE_CLASSIC_BASE_BLOCKS = new RegistryObject[]{STARGATE_MILKYWAY_BASE_BLOCK, STARGATE_PEGASUS_BASE_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_TOLLAN_BASE_BLOCK, STARGATE_MOVIE_BASE_BLOCK};
    public static final RegistryObject<?>[] STARGATE_DHD_BLOCKS = new RegistryObject[]{DHD_PEGASUS, DHD_MILKYWAY};
    public static final RegistryObject<?>[] STARGATE_CLASSIC_ALL_BLOCKS = new RegistryObject[]{STARGATE_MILKYWAY_BASE_BLOCK, STARGATE_MILKYWAY_CHEVRON_BLOCK, STARGATE_MILKYWAY_RING_BLOCK, STARGATE_PEGASUS_BASE_BLOCK, STARGATE_PEGASUS_CHEVRON_BLOCK, STARGATE_PEGASUS_RING_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_UNIVERSE_CHEVRON_BLOCK, STARGATE_UNIVERSE_RING_BLOCK, STARGATE_TOLLAN_BASE_BLOCK, STARGATE_TOLLAN_CHEVRON_BLOCK, STARGATE_TOLLAN_RING_BLOCK, STARGATE_MOVIE_BASE_BLOCK, STARGATE_MOVIE_CHEVRON_BLOCK, STARGATE_MOVIE_RING_BLOCK, STARGATE_ORLIN_BASE_BLOCK, STARGATE_ORLIN_MEMBER_BLOCK};
    public static final RegistryObject<?>[] CAMO_BLOCKS_BLACKLIST = new RegistryObject[]{CAPACITOR_BLOCK, SG_REDSTONE_DIALER_I_BLOCK, SG_REDSTONE_STATE_O_BLOCK};

    public static void register(IEventBus bus) {
        for (RegistryObject i : REGISTER.getEntries().stream().toList()) {
            RegistryObject registryObject = ItemRegistry.REGISTER.register(i.getId().m_135815_(), () -> {
                Object patt11178$temp;
                RegistryObject<CreativeModeTab> tab = null;
                Object patt11039$temp = i.get();
                if (patt11039$temp instanceof ITabbedItem) {
                    ITabbedItem t = (ITabbedItem)patt11039$temp;
                    tab = t.getTab();
                }
                if ((patt11178$temp = i.get()) instanceof IItemBlock) {
                    IItemBlock itemBlock = (IItemBlock)patt11178$temp;
                    return itemBlock.getItemBlock();
                }
                return new JSGBlockItem((Block)i.get(), new Item.Properties(), tab);
            });
        }
        REGISTER.register(bus);
    }

    public static boolean isInBlocksArray(Block block, RegistryObject<?>[] array) {
        for (RegistryObject<?> b : array) {
            if (block != b.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlocksArray(Block block, Block[] array) {
        for (Block b : array) {
            if (block != b) continue;
            return true;
        }
        return false;
    }
}

