/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.activation;

import java.util.List;

public abstract class Activation<K> {
    protected K textureKey;
    private final long stateChange;
    protected boolean dim;
    private final ActivationState state;
    private boolean active;

    public Activation(K textureKey, long stateChange, boolean dim) {
        this.textureKey = textureKey;
        this.stateChange = stateChange;
        this.dim = dim;
        this.state = new ActivationState(dim ? this.getMaxStage() : 0.0f);
        this.active = true;
    }

    protected abstract float getMaxStage();

    protected abstract float getTickMultiplier();

    public Activation<K> inactive() {
        this.active = false;
        return this;
    }

    public Activation<K> active() {
        this.active = true;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public ActivationState activate(long worldTicks, double partialTicks) {
        double stage = ((double)(worldTicks - this.stateChange) + partialTicks) * (double)this.getTickMultiplier();
        if (stage >= 0.0) {
            if (stage <= (double)this.getMaxStage()) {
                if (this.dim) {
                    stage = (double)this.getMaxStage() - stage;
                }
                this.state.stage = (float)stage;
            } else {
                this.onActivated();
                this.state.stage = this.dim ? 0.0f : this.getMaxStage();
                this.state.remove = true;
            }
        }
        return this.state;
    }

    protected void onActivated() {
    }

    public static <K> void iterate(List<Activation<K>> activationList, long ticks, double partialTicks, IActivationCallback<K> callback) {
        int i = 0;
        while (i < activationList.size()) {
            Activation<K> activation = activationList.get(i);
            if (activation.isActive()) {
                ActivationState activationState = activation.activate(ticks, partialTicks);
                callback.run(activation.textureKey, activationState.stage);
                if (activationState.remove) {
                    activationList.remove(activation);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.textureKey.hashCode();
        result = 31 * result + (this.dim ? 1231 : 1237);
        result = 31 * result + (int)(this.stateChange ^ this.stateChange >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activation other = (Activation)obj;
        if (!this.textureKey.equals(other.textureKey)) {
            return false;
        }
        if (this.dim != other.dim) {
            return false;
        }
        return this.stateChange == other.stateChange;
    }

    public static class ActivationState {
        public float stage;
        public boolean remove = false;

        public ActivationState(float stage) {
            this.stage = stage;
        }
    }

    public static interface IActivationCallback<K> {
        public void run(K var1, float var2);
    }
}

