/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dialhomedevice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.raycaster.instances.RaycasterDHD;
import dev.tauri.jsg.raycaster.util.RayCastedButton;
import dev.tauri.jsg.renderer.BlockRenderer;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.util.JSGColorUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DHDAbstractRenderer<S extends DHDAbstractRendererState>
implements BlockEntityRenderer<DHDAbstractBE> {
    public DHDAbstractBE tileEntity;
    public PoseStack stack;
    public MultiBufferSource source;
    public Level level;
    public float partialTicks;
    public S rendererState;

    public DHDAbstractRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @ParametersAreNonnullByDefault
    public void render(DHDAbstractBE te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        this.tileEntity = te;
        this.rendererState = te.getRendererStateClient();
        this.stack = poseStack;
        this.source = bufferSource;
        OBJModel.packedLight = combinedLight;
        this.partialTicks = partialTicks;
        OBJModel.source = bufferSource;
        if (this.rendererState != null && te.m_58904_() != null) {
            this.level = te.m_58904_();
            this.level.m_46465_();
            BlockState state = te.m_58904_().m_8055_(te.m_58899_());
            if (state.m_60734_() != this.getDHDBlock()) {
                return;
            }
            this.stack.m_85836_();
            if (((Boolean)state.m_61143_((Property)JSGProperties.SNOWY)).booleanValue()) {
                BlockRenderer.renderBlock(this.level, te.m_58899_(), Blocks.f_50125_.m_49966_(), new BlockPos(0, 0, 0), this.stack, this.source, combinedLight, combinedOverlay);
            }
            this.stack.m_85837_(0.5, 0.0, 0.5);
            this.stack.m_252781_(Axis.f_252436_.m_252977_((float)((Integer)Objects.requireNonNull(this.level).m_8055_(this.tileEntity.m_58899_()).m_61143_((Property)JSGProperties.ROTATION_PROPERTY)).intValue() * -22.5f));
            if (((Boolean)JSGConfig.Debug.renderBoundingBoxes.get()).booleanValue() || Minecraft.m_91087_().m_91290_().m_114377_()) {
                this.stack.m_85836_();
                for (RayCastedButton btn : RaycasterDHD.BUTTONS) {
                    btn.render(this.stack);
                }
                this.stack.m_85849_();
            }
            this.renderDHD();
            this.renderSymbols();
            this.stack.m_85849_();
            ((DHDAbstractRendererState)this.rendererState).iterate(this.level, partialTicks);
        }
    }

    public abstract void renderSymbols();

    public abstract void renderDHD();

    public abstract Block getDHDBlock();

    protected void setColorByAddress(DHDAbstractRendererState rendererState, CompoundTag compound, SymbolTypeEnum<?> symbolType, SymbolInterface symbol) {
        if (rendererState == null) {
            return;
        }
        if (compound != null && ((Boolean)JSGConfig.DialHomeDevice.enablePageHint.get()).booleanValue()) {
            if (compound.m_128441_("addressList")) {
                compound = NotebookItem.getSelectedPageFromCompound(compound);
            }
            if (!compound.m_128441_("symbolType")) {
                return;
            }
            if (!compound.m_128441_("address")) {
                return;
            }
            SymbolTypeEnum<?> st = SymbolTypeEnum.byId(compound.m_128451_("symbolType"));
            StargateAddress stargateAddress = new StargateAddress(compound.m_128469_("address"));
            int[] symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
            List<Integer> symbolsToDisplayList = Arrays.stream(symbolsToDisplay).boxed().toList();
            if (st == symbolType && !rendererState.isButtonActive(symbol) && !rendererState.isButtonActive((SymbolInterface)st.getOrigin())) {
                int activatedButtons = rendererState.getActivatedButtons();
                Object displayedSymbol = st.getOrigin();
                if (symbolsToDisplayList.contains(activatedButtons + 1) && activatedButtons <= 7 && !rendererState.stargateIsConnected) {
                    displayedSymbol = stargateAddress.get(activatedButtons);
                } else if (!symbolsToDisplayList.contains(activatedButtons + 1)) {
                    for (int i = activatedButtons + 2; i <= 7; ++i) {
                        if (!symbolsToDisplayList.contains(i)) continue;
                        return;
                    }
                }
                if ((stargateAddress.contains(symbol) || symbol.origin()) && displayedSymbol == symbol) {
                    String sColor = symbol.origin() ? (String)JSGConfig.DialHomeDevice.pageHintColorOrigin.get() : (activatedButtons < 6 ? (String)JSGConfig.DialHomeDevice.pageHintColorNormal.get() : (String)JSGConfig.DialHomeDevice.pageHintColorExtra.get());
                    int color = 0xFFFFFF;
                    try {
                        color = Integer.decode(sColor);
                    }
                    catch (Exception e) {
                        JSG.logger.error("Error while parsing color of dial helper from config!", (Throwable)e);
                    }
                    Color c = JSGColorUtil.toColor(color);
                    OBJModel.setRGB((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f);
                }
            }
        }
    }

    public CompoundTag getNoteBookPage() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return null;
        }
        CompoundTag compound = null;
        ItemStack item = p.m_21120_(InteractionHand.MAIN_HAND);
        if (item.m_41782_()) {
            compound = item.m_41783_();
        } else {
            item = p.m_21120_(InteractionHand.OFF_HAND);
            if (item.m_41782_()) {
                compound = item.m_41783_();
            }
        }
        return compound;
    }
}

