/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.math.Axis;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.ingame.JSGConfigEnumEntry;
import dev.tauri.jsg.config.ingame.JSGEnumConfigOption;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.util.math.MathFunction;
import dev.tauri.jsg.util.math.MathFunctionImpl;
import dev.tauri.jsg.util.math.MathHelper;
import dev.tauri.jsg.util.math.MathRange;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StargateMilkyWayRenderer
extends StargateClassicRenderer<StargateMilkyWayRendererState> {
    public static final Vec3 RING_LOC = new Vec3(0.0, -0.122333, -5.97E-4);
    public static final float GATE_DIAMETER = 10.1815f;
    protected static final MathRange CHEVRON_OPEN_RANGE = new MathRange(0.0f, 1.57f);
    protected static final MathFunction CHEVRON_OPEN_FUNCTION = new MathFunctionImpl(x -> x * x * x * x / 80.0f);
    protected static final MathRange CHEVRON_CLOSE_RANGE = new MathRange(0.0f, 1.428f);
    protected static final MathFunction CHEVRON_CLOSE_FUNCTION = new MathFunctionImpl(x0 -> MathHelper.cos(x0 * 1.1f) / 12.0f);

    public StargateMilkyWayRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate() {
        this.stack.m_85836_();
        ElementEnum.MILKYWAY_GATE.bindTextureAndRender(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        this.stack.m_85849_();
        this.renderRing();
        this.renderChevrons();
    }

    protected void renderRing() {
        this.stack.m_85836_();
        float angularRotation = ((StargateMilkyWayRendererState)this.rendererState).spinHelper.getCurrentSymbol().getAngle();
        if (((StargateMilkyWayRendererState)this.rendererState).spinHelper.getIsSpinning()) {
            angularRotation += ((StargateMilkyWayRendererState)this.rendererState).spinHelper.apply((float)this.level.m_46467_() + this.partialTicks);
        }
        this.stack.m_85837_(StargateMilkyWayRenderer.RING_LOC.f_82479_, StargateMilkyWayRenderer.RING_LOC.f_82481_, StargateMilkyWayRenderer.RING_LOC.f_82480_);
        this.stack.m_252781_(Axis.f_252403_.m_252977_(-angularRotation));
        this.stack.m_85837_(-StargateMilkyWayRenderer.RING_LOC.f_82479_, -StargateMilkyWayRenderer.RING_LOC.f_82481_, -StargateMilkyWayRenderer.RING_LOC.f_82480_);
        ElementEnum.MILKYWAY_RING.bindTextureAndRender(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        ModelLoader.INSTANCE.getModel(SymbolTypeRegistry.MILKYWAY.getOrigin().getModelResource(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), (ResourceKey<Level>)this.level.m_46472_(), false, false, ((JSGConfigEnumEntry)((JSGEnumConfigOption)((StargateClassicBaseBE)this.tileEntity).getConfig().getOption((String)"MWoriginModel")).getValue()).value)).render(this.stack);
        this.stack.m_85849_();
    }

    protected float calculateTopChevronOffset() {
        float tick = (float)(this.level.m_46467_() - ((StargateMilkyWayRendererState)this.rendererState).chevronActionStart) + this.partialTicks;
        float x = tick / 6.0f;
        if (((StargateMilkyWayRendererState)this.rendererState).chevronOpening) {
            if (CHEVRON_OPEN_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_OPEN_FUNCTION.apply(x);
            }
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpen = true;
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpening = false;
        } else if (((StargateMilkyWayRendererState)this.rendererState).chevronClosing) {
            if (CHEVRON_CLOSE_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_CLOSE_FUNCTION.apply(x);
            }
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpen = false;
            ((StargateMilkyWayRendererState)this.rendererState).chevronClosing = false;
        }
        return ((StargateMilkyWayRendererState)this.rendererState).chevronOpen ? 0.08333f : 0.0f;
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        boolean renderEmissive = onlyLight && ((StargateMilkyWayRendererState)this.rendererState).chevronTextureList.getState(chevron) > 2;
        TextureLoader.INSTANCE.getTexture(((StargateMilkyWayRendererState)this.rendererState).chevronTextureList.get(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), chevron, onlyLight)).bindTexture();
        if (chevron.isFinal()) {
            float chevronOffset = this.calculateTopChevronOffset() * 1.5f;
            this.stack.m_85836_();
            this.stack.m_252880_(0.0f, chevronOffset, 0.0f);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(this.stack, renderEmissive);
            this.stack.m_252880_(0.0f, -2.0f * chevronOffset, 0.0f);
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render(this.stack, renderEmissive);
            this.stack.m_85849_();
        } else {
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render(this.stack, renderEmissive);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(this.stack, renderEmissive);
        }
        if (!onlyLight) {
            ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), this.stack);
            ElementEnum.MILKYWAY_CHEVRON_BACK.render(this.stack);
        }
        this.stack.m_85849_();
        OBJModel.resetRGB();
    }
}

