/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.math.Axis;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRenderer;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.renderer.stargate.StargateMovieRendererState;
import dev.tauri.jsg.util.math.MathFunction;
import dev.tauri.jsg.util.math.MathFunctionImpl;
import dev.tauri.jsg.util.math.MathHelper;
import dev.tauri.jsg.util.math.MathRange;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;

public class StargateMovieRenderer
extends StargateMilkyWayRenderer {
    protected static final MathRange CHEVRON_OPEN_RANGE = new MathRange(0.0f, 1.57f);
    protected static final MathFunction CHEVRON_OPEN_FUNCTION = new MathFunctionImpl(x -> x * x * x * x / 80.0f);
    protected static final MathRange CHEVRON_CLOSE_RANGE = new MathRange(0.0f, 1.428f);
    protected static final MathFunction CHEVRON_CLOSE_FUNCTION = new MathFunctionImpl(x0 -> MathHelper.cos(x0 * 1.1f) / 12.0f);

    public StargateMovieRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    protected float calculateTopChevronOffset() {
        float tick = (float)(this.level.m_46467_() - ((StargateMilkyWayRendererState)this.rendererState).chevronActionStart) + this.partialTicks;
        float x = tick / 3.0f;
        if (((StargateMilkyWayRendererState)this.rendererState).chevronOpening) {
            if (CHEVRON_OPEN_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_OPEN_FUNCTION.apply(x);
            }
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpen = true;
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpening = false;
        } else if (((StargateMilkyWayRendererState)this.rendererState).chevronClosing) {
            if (CHEVRON_CLOSE_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_CLOSE_FUNCTION.apply(x);
            }
            ((StargateMilkyWayRendererState)this.rendererState).chevronOpen = false;
            ((StargateMilkyWayRendererState)this.rendererState).chevronClosing = false;
        }
        return ((StargateMilkyWayRendererState)this.rendererState).chevronOpen ? 0.08333f : 0.0f;
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, boolean onlyLight) {
        float chevronOffset;
        if (onlyLight) {
            return;
        }
        OBJModel.resetDynamicLightning();
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        TextureLoader.INSTANCE.getTexture(TextureLoader.INSTANCE.getTextureResource("movie/chevron.png")).bindTexture();
        StargateMovieRendererState castRendererState = (StargateMovieRendererState)this.rendererState;
        if (((StargateMilkyWayRendererState)this.rendererState).doEventHorizonRender && castRendererState.chevronActionIndex != -1) {
            castRendererState.chevronActionIndex = -10;
        }
        float f = chevronOffset = ((StargateMilkyWayRendererState)this.rendererState).doEventHorizonRender && ((StargateMilkyWayRendererState)this.rendererState).chevronTextureList.getState(chevron) > 0 ? 0.08333f : 0.0f;
        if (!((StargateMilkyWayRendererState)this.rendererState).doEventHorizonRender) {
            if (castRendererState.chevronActionIndex >= 0) {
                ChevronEnum targetChevron;
                ChevronEnum chevronEnum = targetChevron = castRendererState.chevronActionModifyFinal ? ChevronEnum.getFinal() : ChevronEnum.valueOf(castRendererState.chevronActionIndex);
                if (targetChevron == chevron) {
                    chevronOffset = this.calculateTopChevronOffset();
                }
            } else if (chevron.index <= -castRendererState.chevronActionIndex || chevron.isFinal() && castRendererState.chevronActionModifyFinal) {
                chevronOffset = this.calculateTopChevronOffset();
            }
        }
        this.stack.m_85836_();
        this.stack.m_252880_(0.0f, chevronOffset *= 2.0f, 0.0f);
        ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(this.stack, false);
        this.stack.m_252880_(0.0f, -2.0f * chevronOffset, 0.0f);
        ElementEnum.MILKYWAY_CHEVRON_MOVING.render(this.stack, false);
        this.stack.m_85849_();
        ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        ElementEnum.MILKYWAY_CHEVRON_BACK.render(this.stack);
        this.stack.m_85849_();
    }

    @Override
    public boolean shouldRenderBackVortex() {
        return true;
    }
}

