/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.math.Axis;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargateUniverseRendererState;
import dev.tauri.jsg.stargate.network.SymbolUniverseEnum;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;

public class StargateUniverseRenderer
extends StargateClassicRenderer<StargateUniverseRendererState> {
    private static final float GATE_DIAMETER = 8.67415f;
    private static final float IRIS_DARK_COLOR = 0.6f;

    public StargateUniverseRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 8.67415f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.14;
    }

    @Override
    protected void renderGate() {
        float angularRotation = ((StargateUniverseRendererState)this.rendererState).spinHelper.getCurrentSymbol().getAngle();
        if (((StargateUniverseRendererState)this.rendererState).spinHelper.getIsSpinning()) {
            angularRotation += ((StargateUniverseRendererState)this.rendererState).spinHelper.apply((float)this.level.m_46467_() + this.partialTicks);
        }
        this.stack.m_252781_(Axis.f_252393_.m_252977_(angularRotation));
        this.stack.m_85836_();
        ElementEnum.UNIVERSE_GATE.bindTextureAndRender(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        this.stack.m_85849_();
        this.renderChevrons();
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay());
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (symbol.modelResource == null) continue;
            this.stack.m_85836_();
            int symbolLight = (int)((double)(((StargateUniverseRendererState)this.rendererState).getSymbolColor(symbol) / 0.6f) * 15.0);
            float maxLight = Math.max(this.combinedLight / 2, LightTexture.m_109885_((int)symbolLight, (int)symbolLight));
            OBJModel.setDynamicLightning(maxLight / 1.572888E7f);
            ModelLoader.INSTANCE.getModel(symbol.modelResource).render(this.stack, symbolLight > 2);
            OBJModel.resetDynamicLightning();
            this.stack.m_85849_();
        }
        ((StargateUniverseRendererState)this.rendererState).iterate(this.level, this.partialTicks);
    }

    @Override
    protected String getEventHorizonTexturePath(StargateAbstractRendererState rendererState, boolean kawoosh) {
        return kawoosh ? "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg" : "textures/tesr/event_horizon_animated_unstable.jpg";
    }

    @Override
    protected void renderKawoosh() {
        this.stack.m_252880_(0.0f, -0.05f, 0.0f);
        this.stack.m_85841_(0.9f, 0.9f, 1.0f);
        super.renderKawoosh();
    }

    @Override
    public void scaleVortex() {
        this.stack.m_85841_(1.2f, 1.2f, 1.0f);
    }

    @Override
    public void renderIris(boolean backOnly) {
        this.stack.m_85836_();
        this.stack.m_252880_(0.0f, -0.05f, 0.0f);
        this.stack.m_85841_(0.887f, 0.887f, 0.887f);
        super.renderIris(backOnly);
        this.stack.m_85849_();
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        float color = ((StargateUniverseRendererState)this.rendererState).chevronTextureList.getColor(chevron);
        if (onlyLight) {
            int chevronLight = (int)(color * 15.0f);
            float maxLight = Math.max(this.combinedLight, LightTexture.m_109885_((int)chevronLight, (int)chevronLight));
            if (chevronLight > 2) {
                OBJModel.setDynamicLightning(maxLight / 1.572888E7f);
            }
        }
        TextureLoader.INSTANCE.getTexture(((StargateUniverseRendererState)this.rendererState).chevronTextureList.get(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay(), chevron, onlyLight)).bindTexture();
        ElementEnum.UNIVERSE_CHEVRON.render(this.stack, onlyLight && color > 0.1f);
        OBJModel.resetDynamicLightning();
        this.stack.m_85849_();
    }

    @Override
    public void setIrisHeatColor(float red) {
        OBJModel.setRGB(0.6f + red * 3.0f, 0.6f, 0.6f, 1.0f);
    }

    @Override
    public float[] getShieldColor() {
        if (this.tileEntity instanceof StargateClassicBaseBE && ((Boolean)((JSGBooleanConfigOption)((StargateClassicBaseBE)this.tileEntity).getConfig().getOption("orangeShield")).getValue()).booleanValue()) {
            return new float[]{1.0f, 0.65f, 0.35f};
        }
        return super.getShieldColor();
    }
}

