/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class CustomSkyObjectRenderer {
    private final ResourceLocation texture;
    public final ResourceLocation dimension;
    private final float rotationSpeed;
    private final float size;
    private final float angleOffsetY;
    private final float angleOffsetX;

    public CustomSkyObjectRenderer(ResourceLocation dimension, ResourceLocation texture, float rotationSpeed, float size, float angleOffsetX, float angleOffsetY) {
        this.dimension = dimension;
        this.texture = new ResourceLocation(texture.m_135827_(), "textures/environment/" + texture.m_135815_() + ".png");
        this.rotationSpeed = rotationSpeed;
        this.size = size * 4.0f;
        this.angleOffsetY = angleOffsetY;
        this.angleOffsetX = angleOffsetX;
    }

    public void render(PoseStack matrixStack, ClientLevel world, float partialTicks) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        float celestialAngle = world.m_46942_(partialTicks) * 360.0f * this.rotationSpeed + this.angleOffsetY;
        matrixStack.m_85836_();
        matrixStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0f + this.angleOffsetX)));
        matrixStack.m_252781_(new Quaternionf().rotateX((float)Math.toRadians(celestialAngle)));
        matrixStack.m_85836_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), -this.size, 100.0f, -this.size).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), this.size, 100.0f, -this.size).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), this.size, 100.0f, this.size).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), -this.size, 100.0f, this.size).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }
}

