/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.admincontroller;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.helpers.JSGMinecraftHelper;
import dev.tauri.jsg.helpers.TemperatureHelper;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRenderer;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.screen.base.JSGButtonClassic;
import dev.tauri.jsg.screen.base.JSGTextFieldClassic;
import dev.tauri.jsg.screen.element.ModeButton;
import dev.tauri.jsg.screen.gui.JSGTexturedGui;
import dev.tauri.jsg.screen.gui.admincontroller.AddressesSection;
import dev.tauri.jsg.screen.gui.admincontroller.Notifier;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiAdminController
extends JSGTexturedGui {
    public static GuiAdminController currentInstance = null;
    public final StargateClassicBaseBE gateTile;
    public final Level world;
    public final BlockPos pos;
    public final Player player;
    public StargateNetwork stargateNetwork;
    public final AddressesSection addressesSection;
    public int mouseX;
    public int mouseY;
    public float partialTicks;
    public int[] center = new int[]{0, 0};
    public int[] gateCenter = this.center;
    public int guiRight;
    public int guiBottom;
    public Notifier notifier = new Notifier();
    public static final int OFFSET = 15;
    public StargateClassicBaseBE imaginaryGateTile = null;
    public int lastDialedAddressLength = -1;
    public long symbolEngagingAnimationStart = -1L;
    public static final int SYMBOL_ANIMATION_LENGTH = 40;

    public GuiAdminController(Player player, Level world, BlockPos pos, StargateNetwork stargateNetwork) {
        super("Admin controller", 512, 256, 512, 256);
        this.world = world;
        this.player = player;
        this.pos = pos;
        BlockEntity te = world.m_7702_(pos);
        this.gateTile = te instanceof StargateClassicBaseBE ? (StargateClassicBaseBE)te : null;
        this.addressesSection = new AddressesSection(this);
        this.stargateNetwork = stargateNetwork;
        currentInstance = this;
        this.regenerateStargate();
    }

    public void regenerateStargate() {
        try {
            this.imaginaryGateTile = (StargateClassicBaseBE)this.gateTile.getClass().getConstructor(BlockPos.class, BlockState.class).newInstance(this.pos, this.gateTile.getCurrentBlockState());
            this.imaginaryGateTile.m_142339_(this.world);
            this.imaginaryGateTile.pos = this.pos;
            ItemStack stack = this.player.m_21120_(this.getHand());
            if (stack.m_41720_() != ItemRegistry.ADMIN_CONTROLLER.get()) {
                return;
            }
            CompoundTag compound = stack.m_41783_();
            if (compound == null) {
                return;
            }
            if (!compound.m_128441_("gateNBT")) {
                return;
            }
            this.imaginaryGateTile.m_142466_(compound.m_128469_("gateNBT"));
            if (this.lastDialedAddressLength == -1) {
                this.lastDialedAddressLength = this.imaginaryGateTile.getDialedAddress().size();
            }
        }
        catch (Exception e) {
            JSG.logger.error("", (Throwable)e);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return GuiCustomMainMenu.getCenterPos(rectWidth, rectHeight, this.xSize, this.ySize);
    }

    public void renderStargate() {
        StargateClassicRendererState rendererState = this.gateTile.getRendererStateClient();
        if (rendererState == null) {
            return;
        }
        BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)this.gateTile);
        StargateAbstractRenderer gateRenderer = null;
        if (!(renderer instanceof StargateAbstractRenderer)) {
            return;
        }
        gateRenderer = (StargateAbstractRenderer)renderer;
        this.stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.stack.m_252880_((float)this.gateCenter[0], (float)this.gateCenter[1], 2.0f);
        this.stack.m_85841_(-17.0f, -17.0f, -17.0f);
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        this.stack.m_85836_();
        OBJModel.renderType = OBJModel.EnumOBJRenderMethod.ADMIN_CONTROLLER;
        gateRenderer.initForGui(this.gateTile, this.graphics);
        gateRenderer.renderWholeGate();
        OBJModel.renderType = OBJModel.EnumOBJRenderMethod.NORMAL;
        this.stack.m_85849_();
        this.stack.m_85849_();
        this.stack.m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public ResourceLocation getBackground() {
        return new ResourceLocation("jsg", "textures/gui/admin_controller/gui_admin_controller.png");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.center = this.getCenterPos(0, 0);
        this.gateCenter = new int[]{this.center[0], this.center[1] - 7};
        this.guiRight = this.xSize;
        this.guiBottom = this.ySize;
        this.addressesSection.guiLeft = 15;
        this.addressesSection.guiTop = 15;
        this.addressesSection.width = 175;
        this.addressesSection.height = this.ySize - 30;
        this.addressesSection.init(true);
    }

    @Override
    public void onGraphicsSet(GuiGraphics graphics) {
        this.addressesSection.graphics = graphics;
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.gateTile == null) {
            return;
        }
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.mouseX = mouseX - this.guiLeft;
        this.mouseY = mouseY - this.guiTop;
        this.partialTicks = partialTicks;
        RenderSystem.enableDepthTest();
        this.renderDialedAddressBoxes();
        this.addressesSection.generateAddressEntries();
        this.addressesSection.renderEntries();
        this.renderGateInfo();
        this.notifier.render(this, 117, 4);
        this.stack.m_85836_();
        this.stack.m_85836_();
        this.stack.m_252880_(0.0f, 0.0f, 180.0f);
        this.renderDialedAddress();
        this.addressesSection.renderFg();
        this.stack.m_85849_();
        this.renderStargate();
        RenderSystem.disableDepthTest();
        this.stack.m_85849_();
    }

    public boolean m_7933_(int typedChar, int keyCode, int t) {
        for (EditBox editBox : this.addressesSection.entriesTextFields) {
            editBox.m_7933_(typedChar, keyCode, t);
        }
        this.addressesSection.searchField.m_7933_(typedChar, keyCode, t);
        return super.m_7933_(typedChar, keyCode, t);
    }

    public boolean m_5534_(char character, int intChar) {
        for (EditBox editBox : this.addressesSection.entriesTextFields) {
            editBox.m_5534_(character, intChar);
        }
        this.addressesSection.searchField.m_5534_(character, intChar);
        return super.m_5534_(character, intChar);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = false;
        for (JSGTextFieldClassic jSGTextFieldClassic : this.addressesSection.entriesTextFields) {
            jSGTextFieldClassic.m_6375_(this.mouseX, this.mouseY, mouseButton);
            result = true;
        }
        this.addressesSection.searchField.m_6375_(this.mouseX, this.mouseY, mouseButton);
        for (ModeButton modeButton : this.addressesSection.dialButtons) {
            modeButton.mouseClickedPerformAction(this.mouseX, this.mouseY, mouseButton);
            result = true;
        }
        for (JSGButtonClassic jSGButtonClassic : this.addressesSection.optionButtons) {
            if (!jSGButtonClassic.f_93623_ || !jSGButtonClassic.m_274382_()) continue;
            jSGButtonClassic.m_7933_((int)mouseX, (int)mouseY, mouseButton);
            jSGButtonClassic.m_7435_(Minecraft.m_91087_().m_91106_());
            result = true;
        }
        return result;
    }

    public boolean m_6050_(double v, double v1, double v2) {
        super.m_6050_(v, v1, v2);
        int wheel = (int)v2;
        if (!GuiHelper.isPointInRegion(this.addressesSection.guiLeft, this.addressesSection.guiTop, this.addressesSection.width, this.addressesSection.height, this.mouseX, this.mouseY)) {
            return false;
        }
        if (wheel != 0) {
            this.addressesSection.scroll(wheel);
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionHand getHand() {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = this.player.m_21120_(hand);
        if (stack.m_41720_() != ItemRegistry.ADMIN_CONTROLLER.get() && (stack = this.player.m_21120_(hand = InteractionHand.OFF_HAND)).m_41720_() != ItemRegistry.ADMIN_CONTROLLER.get()) {
            return InteractionHand.MAIN_HAND;
        }
        return hand;
    }

    public void renderDialedAddress() {
        int i;
        if (this.imaginaryGateTile == null) {
            return;
        }
        if (this.imaginaryGateTile.getStargateState().notInitiating()) {
            return;
        }
        StargateAddressDynamic dialedAddress = this.imaginaryGateTile.getDialedAddress();
        int originId = this.imaginaryGateTile.getOriginId();
        boolean isUniverse = dialedAddress.getSymbolType() == SymbolTypeRegistry.UNIVERSE;
        int height = (this.ySize - 30 - 24) / 9;
        int width = isUniverse ? height / 2 : height;
        int x = this.guiRight - 15 - 20 - width / 2;
        for (i = 0; i < dialedAddress.size() - 1; ++i) {
            int y = 15 + i * (height + 3);
            SymbolInterface symbol = dialedAddress.get(i);
            this.renderSymbol(x, y, width, height, symbol, originId);
        }
        i = dialedAddress.size() - 1;
        if (i >= 0) {
            int targetY = 15 + i * (height + 3);
            int currentX = x;
            int currentY = targetY;
            long currentTick = JSGMinecraftHelper.getPlayerTickClientSide();
            if (this.lastDialedAddressLength != dialedAddress.size()) {
                this.lastDialedAddressLength = dialedAddress.size();
                this.symbolEngagingAnimationStart = currentTick;
            }
            float MAX_SCALE = 3.0f;
            if (this.symbolEngagingAnimationStart != -1L) {
                double stage = (double)(currentTick - this.symbolEngagingAnimationStart) / 40.0;
                if (stage > 1.0) {
                    this.symbolEngagingAnimationStart = -1L;
                } else {
                    float symbolSize = stage <= 0.25 ? (float)(stage / 0.25 * 3.0) : (stage <= 0.5 ? 3.0f : 3.0f - (float)((stage - 0.5) / 0.5 * 2.0));
                    int heightMax = (int)((float)height * 3.0f);
                    int widthMax = isUniverse ? heightMax / 2 : heightMax;
                    int n = width = isUniverse ? height / 2 : (height *= (int)symbolSize);
                    if (stage <= 0.5) {
                        currentX = this.gateCenter[0] - width / 2;
                        currentY = this.gateCenter[1] - height / 2;
                    } else {
                        int minX = this.gateCenter[0] - widthMax / 2;
                        int minY = this.gateCenter[1] - heightMax / 2;
                        currentX = (int)((double)minX + (double)(x - minX) * ((stage - 0.5) / 0.5));
                        currentY = (int)((double)minY + (double)(targetY - minY) * ((stage - 0.5) / 0.5));
                    }
                }
            }
            SymbolInterface symbol = dialedAddress.get(i);
            this.renderSymbol(currentX, currentY, width, height, symbol, originId);
        }
    }

    public void renderDialedAddressBoxes() {
        int i;
        if (this.imaginaryGateTile == null) {
            return;
        }
        StargateAddressDynamic dialedAddress = this.imaginaryGateTile.getDialedAddress();
        for (i = 0; i < dialedAddress.size() - 1; ++i) {
            this.renderSymbolBox(i, false);
        }
        i = dialedAddress.size() - 1;
        if (i >= 0 && this.symbolEngagingAnimationStart == -1L) {
            this.renderSymbolBox(i, this.imaginaryGateTile.isFinalActive());
        }
    }

    public void renderSymbolBox(int symbolIndex, boolean isFinal) {
        if (symbolIndex < 0) {
            symbolIndex = 0;
        }
        if (symbolIndex > 8) {
            symbolIndex = 8;
        }
        String symbolBox = symbolIndex + "_" + (symbolIndex == 8 || symbolIndex >= 6 && isFinal ? "1" : "0");
        ResourceLocation textureLocation = new ResourceLocation("jsg", "textures/gui/admin_controller/symbol_box_" + symbolBox + ".png");
        this.stack.m_85836_();
        RenderSystem.enableBlend();
        EnumStargateState sgState = this.imaginaryGateTile.getStargateState();
        if (sgState.incoming() || sgState.notInitiating() || sgState.unstable()) {
            RenderSystem.setShaderColor((float)0.87058824f, (float)0.54509807f, (float)0.05882353f, (float)1.0f);
        } else if (sgState.failing()) {
            RenderSystem.setShaderColor((float)0.87058824f, (float)0.08627451f, (float)0.05882353f, (float)1.0f);
        } else if (sgState.engaged()) {
            RenderSystem.setShaderColor((float)0.078431375f, (float)0.7647059f, (float)0.05490196f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.03137255f, (float)0.5529412f, (float)0.85490197f, (float)1.0f);
        }
        Texture.bindTextureWithMc(textureLocation);
        GuiHelper.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.xSize, this.ySize, this.texW, this.texH);
        RenderSystem.disableBlend();
        this.stack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderGateInfo() {
        this.regenerateStargate();
        if (this.imaginaryGateTile == null) {
            return;
        }
        String[] s = new String[]{"Gate temp: " + ((TemperatureHelper.EnumTemperatureUnit)((Object)JSGConfig.General.temperatureUnit.get())).getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(this.imaginaryGateTile.gateHeat).toKelvins()), 0), "Iris temp: " + ((TemperatureHelper.EnumTemperatureUnit)((Object)JSGConfig.General.temperatureUnit.get())).getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(this.imaginaryGateTile.irisHeat).toKelvins()), 0), "Time opened: " + this.imaginaryGateTile.getOpenedSecondsToDisplayAsMinutes(), "Energy: " + String.format("%.0f", Float.valueOf(this.imaginaryGateTile.getEnergyStored())) + "RF", "Seconds to close: " + this.imaginaryGateTile.getEnergySecondsToClose(), "Installed capacitors: " + (this.imaginaryGateTile.getPowerTier() - 1), "Gate state: " + String.valueOf((Object)this.imaginaryGateTile.getStargateState())};
        int y = this.guiBottom - 15 - 10 * s.length - 23;
        for (String line : s) {
            int width = this.f_96547_.m_92895_(line);
            int lineX = this.guiRight - 15 - width - 41;
            this.graphics.m_280056_(this.f_96547_, line, lineX, y, 0xFFFFFF, true);
            y += 10;
        }
    }

    public void renderSymbol(int x, int y, int w, int h, SymbolInterface symbol, int originId) {
        if (symbol == null) {
            return;
        }
        this.stack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (symbol.renderIconByMinecraft(originId)) {
            Texture.bindTextureWithMc(symbol.getIconResource(originId));
        } else {
            TextureLoader.INSTANCE.getTexture(symbol.getIconResource(originId)).bindTexture();
        }
        GuiHelper.drawScaledCustomSizeModalRect(x, y, 0.0f, 0.0f, 256, 256, w, h, 256.0f, 256.0f);
        if (GuiHelper.isPointInRegion(x, y, w, h, this.mouseX, this.mouseY)) {
            this.graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)symbol.localize()), this.mouseX, this.mouseY);
        }
        this.stack.m_85849_();
    }

    public void m_7379_() {
        for (JSGTextFieldClassic f : this.addressesSection.entriesTextFields) {
            f.m_93692_(false);
        }
        super.m_7379_();
    }
}

