/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.ChevronTextureList;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRenderer;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.StargateClassicSpinHelper;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUniverseEnum;
import dev.tauri.jsg.util.math.NumberUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL14C;

public enum EnumMainMenuGateType {
    MILKYWAY,
    UNIVERSE,
    PEGASUS;

    public static double coefficient;
    public static float translationZ;

    public static EnumMainMenuGateType random(@Nullable EnumMainMenuGateType previousType) {
        EnumMainMenuGateType enumMainMenuGateType;
        EnumMainMenuGateType newType;
        do {
            int i = new Random().nextInt(3);
            switch (i) {
                default: {
                    enumMainMenuGateType = MILKYWAY;
                    break;
                }
                case 1: {
                    enumMainMenuGateType = PEGASUS;
                    break;
                }
                case 2: {
                    enumMainMenuGateType = UNIVERSE;
                }
            }
        } while ((newType = enumMainMenuGateType) == previousType);
        return newType;
    }

    public void renderGate(int x, int y, float size, double tick) {
        coefficient = 0.75;
        GuiCustomMainMenu.poseStack.m_85836_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        translationZ = (ForgeHooksClient.getGuiFarPlane() - 1200.0f) / size;
        GuiCustomMainMenu.poseStack.m_252880_((float)x, (float)y, 0.0f);
        GuiCustomMainMenu.poseStack.m_85841_(size, -size, size);
        GuiCustomMainMenu.poseStack.m_252880_(0.0f, 0.0f, -translationZ);
        OBJModel.renderType = OBJModel.EnumOBJRenderMethod.GUI;
        switch (this) {
            default: {
                break;
            }
            case MILKYWAY: {
                this.renderMWGate(tick);
                break;
            }
            case PEGASUS: {
                this.renderPEGGate(tick);
                break;
            }
            case UNIVERSE: {
                this.renderUNIGate(tick);
            }
        }
        OBJModel.renderType = OBJModel.EnumOBJRenderMethod.NORMAL;
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private void renderMWGate(double tick) {
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_85837_(StargateMilkyWayRenderer.RING_LOC.f_82479_, StargateMilkyWayRenderer.RING_LOC.f_82481_, StargateMilkyWayRenderer.RING_LOC.f_82480_);
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-(tick * ((double)StargateClassicSpinHelper.A_ANGLE_PER_TICK * coefficient / 2.0)) % 360.0)));
        GuiCustomMainMenu.poseStack.m_85837_(-StargateMilkyWayRenderer.RING_LOC.f_82479_, -StargateMilkyWayRenderer.RING_LOC.f_82481_, -StargateMilkyWayRenderer.RING_LOC.f_82480_);
        ElementEnum.MILKYWAY_RING.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
        ModelLoader.INSTANCE.getModel(SymbolTypeRegistry.MILKYWAY.getOrigin().getModelResource(BiomeOverlayEnum.NORMAL, (ResourceKey<Level>)Level.f_46428_, false, false, 5)).render(GuiCustomMainMenu.poseStack);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList("milkyway/chevron", 7, true);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
                if (light) {
                    float color = chevrons.getColor(chevron);
                    RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.INSTANCE.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevron, light)).bindTexture();
                ElementEnum.MILKYWAY_CHEVRON_MOVING.render(GuiCustomMainMenu.poseStack);
                ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(GuiCustomMainMenu.poseStack);
                if (!light) {
                    ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
                    ElementEnum.MILKYWAY_CHEVRON_BACK.render(GuiCustomMainMenu.poseStack);
                }
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.MILKYWAY_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private void renderUNIGate(double tick) {
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_85841_(1.14f, 1.14f, 1.14f);
        GuiCustomMainMenu.poseStack.m_85836_();
        GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-(tick * ((double)StargateClassicSpinHelper.A_ANGLE_PER_TICK * coefficient / 2.0)) % 360.0)));
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.UNIVERSE_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList("universe/universe_chevron", 9, true);
        chevrons.initClient();
        for (ChevronEnum chevronEnum : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevronEnum.rotation));
                if (light) {
                    float color = chevrons.getColor(chevronEnum);
                    RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.INSTANCE.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevronEnum, light)).bindTexture();
                ElementEnum.UNIVERSE_CHEVRON.render(GuiCustomMainMenu.poseStack);
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(BiomeOverlayEnum.NORMAL);
        for (Enum enum_ : SymbolUniverseEnum.values()) {
            if (((SymbolUniverseEnum)enum_).modelResource == null) continue;
            float color = 0.25f;
            switch (1.$SwitchMap$dev$tauri$jsg$stargate$network$SymbolUniverseEnum[enum_.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    color += 0.6f;
                    break;
                }
            }
            GuiCustomMainMenu.poseStack.m_85836_();
            OBJModel.setDynamicLightning(color);
            ModelLoader.INSTANCE.getModel(((SymbolUniverseEnum)enum_).modelResource).render(GuiCustomMainMenu.poseStack);
            OBJModel.resetDynamicLightning();
            GuiCustomMainMenu.poseStack.m_85849_();
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private void renderPEGGate(double tick) {
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.PEGASUS_RING.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
        GuiCustomMainMenu.poseStack.m_85849_();
        GuiCustomMainMenu.poseStack.m_85836_();
        ElementEnum.PEGASUS_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
        GuiCustomMainMenu.poseStack.m_85849_();
        int glyphsCount = (int)(tick * coefficient / 2.0 % 111.0);
        if (glyphsCount > 36) {
            glyphsCount = 36;
        }
        int chevronsCount = glyphsCount / 4;
        GuiCustomMainMenu.poseStack.m_85836_();
        for (int i = -8; i < glyphsCount - 8; ++i) {
            int ii = i % 36;
            if (ii < 0) {
                ii = 36 + ii;
            }
            ii = 36 - ii;
            this.renderPegasusGlyph(ii, ii);
        }
        GuiCustomMainMenu.poseStack.m_85849_();
        if (chevronsCount == 4) {
            chevronsCount = 3;
        }
        if (chevronsCount == 5) {
            chevronsCount = 3;
        }
        if (chevronsCount > 5) {
            chevronsCount -= 2;
        }
        GuiCustomMainMenu.poseStack.m_85836_();
        ChevronTextureList chevrons = new ChevronTextureList("pegasus/chevron", chevronsCount, chevronsCount == 7);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GuiCustomMainMenu.poseStack.m_85836_();
                GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
                if (light) {
                    float color = chevrons.getColor(chevron);
                    GL14C.glBlendColor((float)color, (float)color, (float)color, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.INSTANCE.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevron, light)).bindTexture();
                ElementEnum.PEGASUS_CHEVRON_MOVING.render(GuiCustomMainMenu.poseStack);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render(GuiCustomMainMenu.poseStack);
                if (!light) {
                    ElementEnum.PEGASUS_CHEVRON_FRAME.bindTextureAndRender(BiomeOverlayEnum.NORMAL, GuiCustomMainMenu.poseStack);
                    ElementEnum.PEGASUS_CHEVRON_BACK.render(GuiCustomMainMenu.poseStack);
                }
                GuiCustomMainMenu.poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    private void renderPegasusGlyph(int glyphId, int slot) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        EmissiveRenderer.renderWithLightOverlay(GuiCustomMainMenu.poseStack, false, () -> {
            Texture.bindTextureWithMc(TextureLoader.INSTANCE.getTextureResource("pegasus/glyphs.png"));
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }, () -> {
            double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
            GuiCustomMainMenu.poseStack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), (double)translationZ + 0.17);
            GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            double radius = 0.94;
            int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
            double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
            float x = (float)((uv[0] + radius) / 2.0);
            float y = (float)((uv[1] + radius) / 2.0);
            float tileSize = 0.27f;
            float uvSize = 0.0625f;
            GuiCustomMainMenu.poseStack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(slot - textureSlot) + 180.0f));
            Matrix4f matrix = GuiCustomMainMenu.poseStack.m_85850_().m_252922_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, -tileSize).m_7421_(x, y).m_5752_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, tileSize).m_7421_(x, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, tileSize).m_7421_(x + uvSize, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, -tileSize).m_7421_(x + uvSize, y).m_5752_();
            tessellator.m_85914_();
        }, GameRenderer::m_172817_);
    }

    static {
        coefficient = 1.0;
        translationZ = 0.0f;
    }
}

