/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.base.JSGButtonClassic;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.screen.util.GuiHelper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MainMenuNotifications {
    public static final MainMenuNotifications INSTANCE = new MainMenuNotifications();
    private static final ResourceLocation NOTIFICATION_TEXTURE = new ResourceLocation("jsg", "textures/gui/mainmenu/popup.png");
    public static final int BUTTONS_ID_START = 40;
    private final HashMap<Integer, Notification> NOTIFICATIONS = new HashMap();
    private int id = 0;
    public Notification currentDisplayed = this.getFirstToDisplay();
    public int width = 0;
    public int height = 0;
    public Minecraft mc = Minecraft.m_91087_();
    public static final int BACKGROUND_WIDTH = 300;
    public static final int BACKGROUND_HEIGHT = 140;

    public static MainMenuNotifications getManager() {
        return INSTANCE;
    }

    public int getId() {
        return this.id;
    }

    public int add(Notification notification) {
        this.NOTIFICATIONS.put(this.getId(), notification);
        return this.id++;
    }

    @Nullable
    public Notification get(int id) {
        return this.NOTIFICATIONS.get(id);
    }

    @Nullable
    public Notification getFirstToDisplay() {
        for (Notification n : this.NOTIFICATIONS.values()) {
            if (n.dismissed) continue;
            return n;
        }
        return null;
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return new int[]{(this.width - rectWidth) / 2, (this.height - rectHeight) / 2};
    }

    public void update() {
        this.currentDisplayed = this.getFirstToDisplay();
    }

    public void render(int mouseX, int mouseY, int winWidth, int winHeight, Screen parentScreen) {
        this.width = winWidth;
        this.height = winHeight;
        if (this.currentDisplayed == null) {
            return;
        }
        GuiCustomMainMenu.poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int[] center = this.getCenterPos(300, 140);
        int x = center[0];
        int y = center[1];
        Texture.bindTextureWithMc(NOTIFICATION_TEXTURE);
        GuiHelper.currentStack = GuiCustomMainMenu.graphics.m_280168_();
        GuiHelper.drawModalRectWithCustomSizedTexture(x, y, 0.0f, 0.0f, 300, 140, 300.0f, 140.0f);
        this.currentDisplayed.render(mouseX, mouseY, this.width, this.height, x, y, parentScreen);
        GuiCustomMainMenu.poseStack.m_85849_();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.currentDisplayed == null) {
            return false;
        }
        if (mouseButton != 0) {
            return false;
        }
        for (JSGButtonClassic guiButton : this.currentDisplayed.buttons) {
            if (!guiButton.m_6375_(mouseX, mouseY, mouseButton)) continue;
            guiButton.m_7435_(this.mc.m_91106_());
            this.currentDisplayed.actionPerformed(guiButton);
            return true;
        }
        return false;
    }

    public static class Notification {
        public boolean dismissed;
        public final String[] lines;
        public final List<JSGButtonClassic> buttons;

        public Notification(List<JSGButtonClassic> buttons, String ... text) {
            this.lines = text;
            this.buttons = buttons;
            this.dismissed = false;
        }

        public void dismiss() {
            this.dismissed = true;
        }

        public void actionPerformed(@Nonnull JSGButtonClassic button) {
        }

        public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
            this.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
        }

        public void renderText(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
            int centerX = MainMenuNotifications.getManager().getCenterPos(0, 0)[0];
            int i = 0;
            for (String s : this.lines) {
                if (parentScreen instanceof GuiCustomMainMenu) {
                    ((GuiCustomMainMenu)parentScreen).drawCenteredString(parentScreen.getMinecraft().f_91062_, s, centerX, rectY + 18 + 10 * i, 0x404040, false);
                } else {
                    GuiCustomMainMenu.graphics.m_280488_(parentScreen.getMinecraft().f_91062_, s, centerX - parentScreen.getMinecraft().f_91062_.m_92895_(s) / 2, rectY + 18 + 10 * i, 0x404040);
                }
                ++i;
            }
        }
    }
}

