/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.dialhomedevice;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.util.ReactorStateEnum;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.SetOpenTabToServer;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.renderer.BlockRenderer;
import dev.tauri.jsg.screen.element.Diode;
import dev.tauri.jsg.screen.element.FluidTankElement;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabBiomeOverlay;
import dev.tauri.jsg.screen.element.tabs.TabbedContainerInterface;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainer;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGui;
import dev.tauri.jsg.screen.util.DHDScreenHelper;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.util.I18n;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class DHDContainerGui
extends AbstractContainerScreen<DHDContainer>
implements TabbedContainerInterface {
    private FluidTankElement tank = null;
    private final List<Diode> diodes = new ArrayList<Diode>(3);
    private final List<Tab> tabs = new ArrayList<Tab>();
    public static final ResourceLocation BACKGROUND = new ResourceLocation("jsg", "textures/gui/container_dhd.png");

    public DHDContainerGui(DHDContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 172;
        this.f_96543_ = 176;
        this.f_96544_ = 173;
        ((DHDContainer)this.f_97732_).tankNaquadah.setFluid(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), 0));
    }

    public void m_7856_() {
        super.m_7856_();
        this.tank = new FluidTankElement(152, 23, 16, 54, ((DHDContainer)this.f_97732_).tankNaquadah);
        this.tabs.clear();
        TabBiomeOverlay overlayTab = StargateContainerGui.createOverlayTab(((DHDContainer)this.f_97732_).dhdTile.getSupportedOverlays(), this.f_97726_, this.f_97727_, this.getGuiLeft(), this.getGuiTop());
        this.tabs.add(overlayTab);
        ((DHDContainer)this.f_97732_).f_38839_.set(5, (Object)overlayTab.createAndSaveSlot((SlotHandler)((DHDContainer)this.f_97732_).m_38853_(5)));
        this.diodes.add(new Diode((Screen)this, 8, 18, I18n.format("gui.dhd.crystalStatus")).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.format("gui.dhd.no_crystal")).putStatus(Diode.DiodeStatus.ON, I18n.format("gui.dhd.crystal_ok")).setStatusMapper(() -> ((DHDContainer)this.f_97732_).slotCrystal.m_6657_() ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((Screen)this, 17, 18, I18n.format("gui.dhd.linkStatus")).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.format("gui.dhd.not_linked")).putStatus(Diode.DiodeStatus.ON, I18n.format("gui.dhd.linked")).setStatusMapper(() -> ((DHDContainer)this.f_97732_).dhdTile.isLinkedClient ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((Screen)this, 26, 18, I18n.format("gui.dhd.reactorStatus")).putStatus(Diode.DiodeStatus.OFF, I18n.format("gui.dhd.no_fuel")).putStatus(Diode.DiodeStatus.WARN, I18n.format("gui.dhd.standby")).putStatus(Diode.DiodeStatus.ON, I18n.format("gui.dhd.running")).setStatusMapper(() -> switch (((DHDContainer)this.f_97732_).dhdTile.getReactorState()) {
            case ReactorStateEnum.ONLINE -> Diode.DiodeStatus.ON;
            case ReactorStateEnum.STANDBY -> Diode.DiodeStatus.WARN;
            default -> Diode.DiodeStatus.OFF;
        }).setStatusStringMapper(() -> switch (((DHDContainer)this.f_97732_).dhdTile.getReactorState()) {
            case ReactorStateEnum.NOT_LINKED -> I18n.format("gui.dhd.not_linked");
            case ReactorStateEnum.NO_CRYSTAL -> I18n.format("gui.dhd.no_crystal");
            default -> null;
        }));
    }

    public void updateTank() {
        int capacity = (Integer)JSGConfig.DialHomeDevice.fluidCapacity.get();
        if (((DHDContainer)this.f_97732_).dhdTile.hasUpgrade(DHDAbstractBE.DHDUpgradeEnum.CAPACITY_UPGRADE)) {
            capacity = (int)((double)capacity * (Double)JSGConfig.DialHomeDevice.capacityUpgradeMultiplier.get());
        }
        if (capacity != ((DHDContainer)this.f_97732_).tankNaquadah.getCapacity()) {
            ((DHDContainer)this.f_97732_).tankNaquadah.setCapacity(capacity);
        }
        if (((DHDContainer)this.f_97732_).tankNaquadah.getFluidAmount() > capacity) {
            ((DHDContainer)this.f_97732_).tankNaquadah.setFluid(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), capacity));
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        GuiHelper.currentStack = graphics.m_280168_();
        this.updateTank();
        GuiHelper.renderTransparentBackground(graphics, (Screen)this);
        Tab.updatePositions(this.tabs);
        int i = 5;
        Tab.SlotTab slot = ((Tab.SlotTab)((DHDContainer)this.f_97732_).m_38853_(i)).updatePos();
        slot.setSlotIndex(i);
        ((DHDContainer)this.f_97732_).f_38839_.set(i, (Object)slot);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        TextureAtlasSprite sprite;
        RenderSystem.disableDepthTest();
        for (Tab tab : this.tabs) {
            tab.render(graphics, mouseX, mouseY);
        }
        Texture.bindTextureWithMc(BACKGROUND);
        GuiHelper.drawTexturedModalRect(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.f_97726_, this.f_97727_);
        if (((DHDContainer)this.f_97732_).slotCrystal.m_6657_()) {
            RenderSystem.enableBlend();
            this.drawCrystal();
            RenderSystem.disableBlend();
        }
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        block6: for (int i = 1; i < 4; ++i) {
            if (!((DHDContainer)this.f_97732_).m_38853_(i).m_6657_()) continue;
            switch (i) {
                case 1: {
                    GuiHelper.drawTexturedModalRect(guiLeft + 16, guiTop + 57, 121, 173, 57, 12);
                    continue block6;
                }
                case 2: {
                    GuiHelper.drawTexturedModalRect(guiLeft + 34, guiTop + 57, 121, 185, 39, 9);
                    continue block6;
                }
                case 3: {
                    GuiHelper.drawTexturedModalRect(guiLeft + 52, guiTop + 57, 121, 194, 21, 6);
                    continue block6;
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((DHDContainer)this.f_97732_).dhdTile.getReactorState() == ReactorStateEnum.ONLINE && (sprite = BlockRenderer.getFluidTexture(((DHDContainer)this.f_97732_).tankNaquadah.getFluid(), BlockRenderer.FluidTextureType.STILL)) != null) {
            int i;
            GuiHelper.currentStack = graphics.m_280168_();
            for (i = 0; i < 3; ++i) {
                GuiHelper.drawTexturedRectScaled(guiLeft + 103 + 16 * i, guiTop + 60 + 16, sprite, 16, 16, 1.0f);
            }
            for (i = 0; i < 5; ++i) {
                GuiHelper.drawTexturedRectScaled(guiLeft + 87 + 16 * i, guiTop + 87, sprite, 16, 16, 0.625f);
            }
        }
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(BACKGROUND);
        GuiHelper.drawTexturedModalRect(guiLeft + 103, guiTop + 60, 0, 173, 48, 16);
        GuiHelper.drawTexturedModalRect(guiLeft + 84, guiTop + 77, 0, 189, 84, 10);
        RenderSystem.disableBlend();
        this.drawAncientTitle();
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        int i;
        RenderSystem.disableDepthTest();
        graphics.m_280056_(this.f_96547_, I18n.format("gui.upgrades"), 8, 29, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("container.inventory"), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        this.tank.renderTank(graphics);
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(BACKGROUND);
        GuiHelper.drawTexturedModalRect(152, 23, 176, 32, 16, 54);
        RenderSystem.disableBlend();
        boolean[] statuses = new boolean[this.diodes.size()];
        for (i = 0; i < this.diodes.size(); ++i) {
            statuses[i] = this.diodes.get(i).render(mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        for (i = 0; i < this.diodes.size(); ++i) {
            if (!statuses[i]) continue;
            this.diodes.get(i).renderTooltip(graphics, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        this.tank.renderTooltip(graphics, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        for (Tab tab : this.tabs) {
            tab.renderFg(graphics, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab((int)mouseX, (int)mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                ((DHDContainer)this.f_97732_).setOpenTabId(i);
            } else {
                ((DHDContainer)this.f_97732_).setOpenTabId(-1);
            }
            JSGPacketHandler.sendToServer(new SetOpenTabToServer(((DHDContainer)this.f_97732_).getOpenTabId()));
            break;
        }
        return true;
    }

    @Override
    public List<Rect2i> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }

    public void drawCrystal() {
        DHDScreenHelper helper = ((DHDContainer)this.f_97732_).dhdTile.getScreenHelper();
        GuiHelper.drawTexturedModalRect(this.getGuiLeft() + 77, this.getGuiTop() + 21, helper.crystalTexX, helper.crystalTexY, 24, 32);
    }

    public void drawAncientTitle() {
        DHDScreenHelper helper = ((DHDContainer)this.f_97732_).dhdTile.getScreenHelper();
        GuiHelper.drawTexturedModalRect(this.getGuiLeft() + 136, this.getGuiTop() + 4, helper.titleTexX, helper.titleTexY, 35, 8);
    }
}

