/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.JSGIntRangeConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.helpers.TemperatureHelper;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.SetOpenTabToServer;
import dev.tauri.jsg.packet.packets.stargate.SaveConfigToServer;
import dev.tauri.jsg.packet.packets.stargate.SaveIrisCodeToServer;
import dev.tauri.jsg.power.general.LargeEnergyStorage;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.screen.element.tabs.TabBiomeOverlay;
import dev.tauri.jsg.screen.element.tabs.TabConfig;
import dev.tauri.jsg.screen.element.tabs.TabInfo;
import dev.tauri.jsg.screen.element.tabs.TabIris;
import dev.tauri.jsg.screen.element.tabs.TabScrollAble;
import dev.tauri.jsg.screen.element.tabs.TabSideEnum;
import dev.tauri.jsg.screen.element.tabs.TabbedContainerInterface;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainer;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUsage;
import dev.tauri.jsg.util.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class StargateContainerGui
extends AbstractContainerScreen<StargateContainer>
implements TabbedContainerInterface {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_stargate.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final Map<SymbolTypeEnum<?>, TabAddress> addressTabs = new LinkedHashMap();
    private TabIris irisTab;
    private TabConfig configTab;
    private TabInfo infoTab;
    private int energyStored;
    private int maxEnergyStored;
    private final BlockPos pos;

    public static TabConfig createConfigTab(JSGTileEntityConfig config, int guiwidth, int guiheight, int leftPos, int topPos) {
        return (TabConfig)TabConfig.builder().setConfig(config).setGuiSize(guiwidth, guiheight).setGuiPosition(leftPos, topPos).setTabPosition(-21, 77).setOpenX(-128).setHiddenX(-6).setTabSize(128, 96).setTabTitle(I18n.format("gui.configuration")).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 165).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(326, 66).build();
    }

    public static TabBiomeOverlay createOverlayTab(EnumSet<BiomeOverlayEnum> supportedOverlay, int guiwidth, int guiheight, int leftPos, int topPos) {
        return (TabBiomeOverlay)TabBiomeOverlay.builder().setSupportedOverlays(supportedOverlay).setSlotTexture(6, 179).setGuiSize(guiwidth, guiheight).setGuiPosition(leftPos, topPos).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.format("gui.stargate.biome_overlay")).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 66).build();
    }

    public StargateContainerGui(StargateContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 173;
        this.f_96543_ = 176;
        this.f_96544_ = 173;
        this.pos = container.gateTile.m_58899_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabs.clear();
        int i = 0;
        for (SymbolTypeEnum<?> type : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            Tab.TabBuilder tab = TabAddress.builder().setGateTile(((StargateContainer)this.f_97732_).gateTile).setSymbolType(type).setProgressColor(10009849).setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(-21, 11 + 22 * i).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.format("gui.stargate." + type.getId() + "_address")).setTabSide(TabSideEnum.LEFT);
            tab = type.finalizeAddressTab(tab);
            this.addressTabs.put(type, (TabAddress)tab.build());
            ++i;
        }
        this.configTab = StargateContainerGui.createConfigTab(((StargateContainer)this.f_97732_).gateTile.getConfig(), this.f_97726_, this.f_97727_, this.f_97735_, this.f_97736_);
        TabBiomeOverlay overlayTab = StargateContainerGui.createOverlayTab(((StargateContainer)this.f_97732_).gateTile.getSupportedOverlays(), this.f_97726_, this.f_97727_, this.f_97735_, this.f_97736_);
        this.irisTab = (TabIris)TabIris.builder().setCode(((StargateContainer)this.f_97732_).gateTile.getIrisCode()).setIsUniverse(((StargateContainer)this.f_97732_).gateTile.getSymbolType() == SymbolTypeRegistry.UNIVERSE).setIrisMode(((StargateContainer)this.f_97732_).gateTile.getIrisMode()).setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(69, 24).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.format("gui.stargate.iris_code")).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 88).build();
        this.infoTab = (TabInfo)TabInfo.builder().setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(45, 46).setOpenX(176).setHiddenX(30).setTabSize(152, 51).setTabTitle(I18n.format("gui.stargate.info")).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(131, 6).setIconSize(22, 22).setIconTextureLocation(326, 88).build();
        this.irisTab.setOnTabClose(this::saveIrisCode);
        this.configTab.setOnTabClose(this::saveConfig);
        this.tabs.addAll(this.addressTabs.values());
        this.tabs.add(this.configTab);
        this.tabs.add(overlayTab);
        this.tabs.add(this.irisTab);
        this.tabs.add(this.infoTab);
        int ii = 0;
        for (TabAddress tab : this.addressTabs.values()) {
            if (ii + 7 == 10) {
                ++ii;
            }
            ((StargateContainer)this.f_97732_).f_38839_.set(ii + 7, (Object)tab.createSlot((SlotHandler)((StargateContainer)this.f_97732_).m_38853_(ii + 7)));
            ++ii;
        }
        ((StargateContainer)this.f_97732_).f_38839_.set(10, (Object)overlayTab.createAndSaveSlot((SlotHandler)((StargateContainer)this.f_97732_).m_38853_(10)));
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        RenderSystem.disableDepthTest();
        GuiHelper.currentStack = graphics.m_280168_();
        if (this.irisTab.isVisible() && !this.irisTab.isOpen()) {
            if (this.irisTab.getIrisMode() != ((StargateContainer)this.f_97732_).gateTile.getIrisMode()) {
                this.irisTab.updateValue(((StargateContainer)this.f_97732_).gateTile.getIrisMode());
            }
            if (!Objects.equals(this.irisTab.getCode(), ((StargateContainer)this.f_97732_).gateTile.getIrisCode())) {
                this.irisTab.updateValue(((StargateContainer)this.f_97732_).gateTile.getIrisCode());
            }
        }
        if (((StargateContainer)this.f_97732_).gateTile.getConfig().getOptions().size() != this.configTab.getConfig(false).getOptions().size()) {
            this.configTab.updateConfig(((StargateContainer)this.f_97732_).gateTile.getConfig(), true);
        }
        graphics.m_280168_().m_85836_();
        for (Tab tab : this.tabs) {
            tab.render(graphics, mouseX, mouseY);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 0.2f);
        Texture.bindTextureWithMc(BACKGROUND_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512.0f, 512.0f);
        for (i = 0; i < 3 - ((StargateContainer)this.f_97732_).gateTile.getSupportedCapacitors(); ++i) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 151 - 18 * i, this.f_97736_ + 27, 24.0f, 180.0f, 16, 16, 512.0f, 512.0f);
        }
        for (i = ((StargateContainer)this.f_97732_).gateTile.getPowerTier(); i < 4; ++i) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 10 + 39 * i, this.f_97736_ + 69, 0.0f, 173.0f, 39, 6, 512.0f, 512.0f);
        }
        int width = Math.round((float)this.energyStored / (float)((Integer)JSGConfig.Stargate.stargateEnergyStorage.get()).intValue() * 156.0f);
        GuiHelper.drawGradientRect(graphics.m_280168_(), this.f_97735_ + 10, this.f_97736_ + 69, this.f_97735_ + 10 + width, this.f_97736_ + 69 + 6, -3397592, -9234922);
        int[] pos = ((StargateContainer)this.f_97732_).gateTile.getSymbolType().getAncientTitlePos();
        GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 137, this.f_97736_ + 4, pos[0], pos[1], 35, 8, 512.0f, 512.0f);
        boolean drawICFirstCable = false;
        boolean drawICSecondCable = false;
        block12: for (int i2 = 0; i2 < 7; ++i2) {
            if (!((StargateContainer)this.f_97732_).m_38853_(i2).m_6657_()) continue;
            if (i2 < 4) {
                drawICFirstCable = true;
            }
            switch (i2) {
                case 0: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 16, this.f_97736_ + 44, 18.0f, 239.0f, 31, 15, 512.0f, 512.0f);
                    continue block12;
                }
                case 1: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 34, this.f_97736_ + 44, 3.0f, 239.0f, 13, 11, 512.0f, 512.0f);
                    continue block12;
                }
                case 2: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 52, this.f_97736_ + 44, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
                    continue block12;
                }
                case 3: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 59, this.f_97736_ + 44, 33.0f, 254.0f, 13, 11, 512.0f, 512.0f);
                    continue block12;
                }
                case 4: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 121, this.f_97736_ + 44, 0.0f, 225.0f, 14, 12, 512.0f, 512.0f);
                    continue block12;
                }
                case 5: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 139, this.f_97736_ + 44, 14.0f, 225.0f, 4, 6, 512.0f, 512.0f);
                    continue block12;
                }
                case 6: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 147, this.f_97736_ + 44, 18.0f, 225.0f, 14, 14, 512.0f, 512.0f);
                    continue block12;
                }
            }
        }
        if (((StargateContainer)this.f_97732_).m_38853_(11).m_6657_()) {
            drawICSecondCable = true;
            ItemStack stack = ((StargateContainer)this.f_97732_).m_38853_(11).m_7993_();
            if (stack.m_41720_() == ItemRegistry.UPGRADE_SHIELD.get()) {
                GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 98, this.f_97736_ + 33, 0.0f, 197.0f, 37, 28, 512.0f, 512.0f);
            }
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 59, this.f_97736_ + 44, 0.0f, 254.0f, 31, 15, 512.0f, 512.0f);
        }
        if (drawICFirstCable) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 50, this.f_97736_ + 62, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
        }
        if (drawICSecondCable) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 54, this.f_97736_ + 62, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        RenderSystem.disableDepthTest();
        if (this.infoTab != null) {
            this.infoTab.clearStrings();
            int y = 22;
            long openedSince = ((StargateContainer)this.f_97732_).gateTile.openedSince;
            if (openedSince > 0L) {
                long openedSeconds = ((StargateContainer)this.f_97732_).gateTile.getOpenedSeconds();
                String format = ChatFormatting.DARK_GREEN.toString();
                int maxTime = (Integer)((JSGIntRangeConfigOption)((StargateContainer)this.f_97732_).gateTile.getConfig().getOption("timeLimitTime")).getValue();
                if ((double)openedSeconds >= (double)maxTime * 0.75) {
                    format = ChatFormatting.YELLOW.toString();
                }
                if (openedSeconds >= (long)maxTime) {
                    format = ChatFormatting.RED.toString();
                }
                String openedTime = I18n.format("gui.stargate.state.opened") + " " + format + ((StargateContainer)this.f_97732_).gateTile.getOpenedSecondsToDisplayAsMinutes();
                this.infoTab.addString(new TabInfo.InfoString(openedTime, 4, y));
                y += 9;
            }
            double gateTemperature = ((StargateContainer)this.f_97732_).gateTile.gateHeat;
            double irisTemperature = ((StargateContainer)this.f_97732_).gateTile.irisHeat;
            String format = ChatFormatting.DARK_GREEN.toString();
            if (gateTemperature >= StargateClassicBaseBE.GATE_MAX_HEAT * 0.5) {
                format = ChatFormatting.YELLOW.toString();
            }
            if (gateTemperature >= StargateClassicBaseBE.GATE_MAX_HEAT * 0.75) {
                format = ChatFormatting.RED.toString();
            }
            this.infoTab.addString(new TabInfo.InfoString(I18n.format("gui.stargate.state.gate_temp") + " " + format + ((TemperatureHelper.EnumTemperatureUnit)((Object)JSGConfig.General.temperatureUnit.get())).getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(gateTemperature).toKelvins()), 0), 4, y));
            y += 9;
            if (((StargateContainer)this.f_97732_).gateTile.hasPhysicalIris()) {
                double maxHeat = ((StargateContainer)this.f_97732_).gateTile.getMaxIrisHeat();
                format = ChatFormatting.DARK_GREEN.toString();
                if (irisTemperature > maxHeat * 0.5) {
                    format = ChatFormatting.YELLOW.toString();
                }
                if (irisTemperature > maxHeat * 0.75) {
                    format = ChatFormatting.RED.toString();
                }
                this.infoTab.addString(new TabInfo.InfoString(I18n.format("gui.stargate.state.iris_temp") + " " + format + ((TemperatureHelper.EnumTemperatureUnit)((Object)JSGConfig.General.temperatureUnit.get())).getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(irisTemperature).toKelvins()), 0), 4, y));
            }
        }
        GuiHelper.renderTransparentBackground(graphics, (Screen)this);
        boolean hasAddressUpgrade = false;
        boolean hasIrisUpgrade = !((StargateContainer)this.f_97732_).m_38853_(11).m_7993_().m_41619_();
        for (Map.Entry<SymbolTypeEnum<?>, TabAddress> entry : this.addressTabs.entrySet()) {
            entry.getValue().setVisible(false);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            ItemStack itemStack = ((StargateContainer)this.f_97732_).m_38853_(i2).m_7993_();
            if (itemStack.m_41619_()) continue;
            for (Map.Entry<SymbolTypeEnum<?>, TabAddress> entry : this.addressTabs.entrySet()) {
                if (itemStack.m_41720_() != entry.getKey().getGlyphUpgrade()) continue;
                entry.getValue().setVisible(true);
            }
            StargateClassicBaseBE.StargateUpgradeEnum upgrade = StargateClassicBaseBE.StargateUpgradeEnum.valueOf(itemStack.m_41720_());
            if (upgrade == null || upgrade != StargateClassicBaseBE.StargateUpgradeEnum.CHEVRON_UPGRADE) continue;
            hasAddressUpgrade = true;
        }
        for (Map.Entry<SymbolTypeEnum<?>, TabAddress> entry : this.addressTabs.entrySet()) {
            entry.getValue().setMaxSymbols(entry.getKey().getMaxSymbolsDisplay(hasAddressUpgrade));
        }
        this.irisTab.setVisible(hasIrisUpgrade);
        this.configTab.setVisible(((StargateContainer)this.f_97732_).hasCreative);
        Tab.updatePositions(this.tabs);
        LargeEnergyStorage energyStorageInternal = (LargeEnergyStorage)((Object)((StargateContainer)this.f_97732_).gateTile.getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        this.energyStored = energyStorageInternal.getEnergyStoredInternally();
        this.maxEnergyStored = energyStorageInternal.getMaxEnergyStoredInternally();
        for (i = 4; i < 7; ++i) {
            Optional energyStorage = ((StargateContainer)this.f_97732_).m_38853_(i).m_7993_().getCapability(ForgeCapabilities.ENERGY, null).resolve();
            if (energyStorage.isEmpty()) continue;
            this.energyStored += ((IEnergyStorage)energyStorage.get()).getEnergyStored();
            this.maxEnergyStored += ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored();
        }
        for (i = 7; i < 11; ++i) {
            Tab.SlotTab slot = ((Tab.SlotTab)((StargateContainer)this.f_97732_).m_38853_(i)).updatePos();
            slot.setSlotIndex(i);
            ((StargateContainer)this.f_97732_).f_38839_.set(i, (Object)slot);
        }
        graphics.m_280168_().m_85836_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        graphics.m_280168_().m_85849_();
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_7286_(graphics, partialTicks, mouseX, mouseY);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        String caps = I18n.format("gui.stargate.capacitors");
        graphics.m_280056_(this.f_96547_, caps, this.f_97726_ - 8 - this.f_96547_.m_92895_(caps), 16, 0x404040, false);
        String energyPercent = String.format("%.2f", Float.valueOf((float)this.energyStored / (float)this.maxEnergyStored * 100.0f)) + " %";
        graphics.m_280056_(this.f_96547_, energyPercent, this.f_97726_ - 8 - this.f_96547_.m_92895_(energyPercent), 79, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("gui.upgrades"), 8, 16, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("container.inventory"), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        for (Tab tab : this.tabs) {
            tab.renderFg(graphics, mouseX, mouseY);
        }
        int transferred = ((StargateContainer)this.f_97732_).gateTile.getEnergyTransferredLastTick();
        ChatFormatting transferredFormatting = ChatFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = ChatFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = ChatFormatting.RED;
        }
        float toClose = ((StargateContainer)this.f_97732_).gateTile.getEnergySecondsToClose();
        ChatFormatting toCloseFormatting = ChatFormatting.GRAY;
        if (toClose > 0.0f) {
            toCloseFormatting = toClose < (float)((Integer)JSGConfig.Stargate.instabilitySeconds.get()).intValue() ? ChatFormatting.DARK_RED : ChatFormatting.GREEN;
        }
        if (GuiHelper.isPointInRegion(10, 69, 156, 6, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop())) {
            List<String> power = Arrays.asList(I18n.format("gui.stargate.energyBuffer"), String.valueOf(ChatFormatting.GRAY) + String.format("%,d / %,d RF", this.energyStored, this.maxEnergyStored), String.valueOf(transferredFormatting) + transferredSign + String.format("%,d RF/t", transferred), String.valueOf(toCloseFormatting) + String.format("%.2f s", Float.valueOf(toClose)));
            GuiHelper.drawHoveringText(graphics, this.f_96547_, power, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab((int)mouseX, (int)mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                ((StargateContainer)this.f_97732_).setOpenTabId(i);
            } else {
                ((StargateContainer)this.f_97732_).setOpenTabId(-1);
            }
            JSGPacketHandler.sendToServer(new SetOpenTabToServer(((StargateContainer)this.f_97732_).getOpenTabId()));
            break;
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
        }
        return true;
    }

    public boolean m_6050_(double v, double v1, double v2) {
        super.m_6050_(v, v1, v2);
        int wheel = (int)v2;
        if (wheel != 0) {
            for (Tab tab : this.tabs) {
                if (!(tab instanceof TabScrollAble) || !tab.isVisible() || !tab.isOpen() || !tab.isCursorOnTabBody((int)v, (int)v1)) continue;
                ((TabScrollAble)tab).scroll(wheel);
                return true;
            }
        }
        return false;
    }

    public boolean m_7933_(int typedChar, int keyCode, int t) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.keyTyped((char)typedChar, keyCode)) continue;
            return true;
        }
        return super.m_7933_(typedChar, keyCode, t);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.charTyped(typedChar, keyCode)) continue;
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public void m_7379_() {
        this.saveConfig();
        this.saveIrisCode();
        super.m_7379_();
    }

    private void saveConfig() {
        JSGPacketHandler.sendToServer(new SaveConfigToServer(this.pos, this.configTab.config));
        ((StargateContainer)this.f_97732_).gateTile.setConfig(this.configTab.getConfig(true));
    }

    private void saveIrisCode() {
        JSGPacketHandler.sendToServer(new SaveIrisCodeToServer(this.pos, this.irisTab.getCode(), this.irisTab.getIrisMode()));
        ((StargateContainer)this.f_97732_).gateTile.setIrisCode(this.irisTab.getCode());
        ((StargateContainer)this.f_97732_).gateTile.setIrisMode(this.irisTab.getIrisMode());
    }

    @Override
    public List<Rect2i> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }
}

