/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.state.State;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class StargateContainerGuiUpdate
extends State {
    public int energyStored;
    public int transferedLastTick;
    public float secondsToClose;
    public EnumIrisMode irisMode;
    public String irisCode;
    public long openedSince;
    public double gateTemp;
    public double irisTemp;
    public int pageProgress;

    public StargateContainerGuiUpdate() {
    }

    public StargateContainerGuiUpdate(int energyStored, int transferedLastTick, float secondsToClose, EnumIrisMode irisMode, String irisCode, long openedSince, double gateTemp, double irisTemp, int pageProgress) {
        this.energyStored = energyStored;
        this.transferedLastTick = transferedLastTick;
        this.secondsToClose = secondsToClose;
        this.irisMode = irisMode;
        this.irisCode = irisCode;
        this.openedSince = openedSince;
        this.gateTemp = gateTemp;
        this.irisTemp = irisTemp;
        this.pageProgress = pageProgress;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStored);
        buf.writeInt(this.transferedLastTick);
        buf.writeFloat(this.secondsToClose);
        buf.writeByte((int)this.irisMode.id);
        buf.writeInt(this.irisCode.length());
        buf.writeCharSequence((CharSequence)this.irisCode, StandardCharsets.UTF_8);
        buf.writeLong(this.openedSince);
        buf.writeDouble(this.gateTemp);
        buf.writeDouble(this.irisTemp);
        buf.writeInt(this.pageProgress);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStored = buf.readInt();
        this.transferedLastTick = buf.readInt();
        this.secondsToClose = buf.readFloat();
        this.irisMode = EnumIrisMode.getValue(buf.readByte());
        int codeSize = buf.readInt();
        this.irisCode = buf.readCharSequence(codeSize, StandardCharsets.UTF_8).toString();
        this.openedSince = buf.readLong();
        this.gateTemp = buf.readDouble();
        this.irisTemp = buf.readDouble();
        this.pageProgress = buf.readInt();
    }
}

