/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelper {
    public static PoseStack currentStack = null;

    public static void translateFor3D() {
        currentStack.m_85841_(1.0f, -1.0f, 1.0f);
    }

    public static void drawTexturedRectScaled(int xLeftCoord, int yBottomCoord, TextureAtlasSprite textureSprite, int maxWidth, int maxHeight, float scaleHeight) {
        maxHeight = (int)((float)maxHeight * scaleHeight);
        GuiHelper.drawTexturedRect(xLeftCoord, yBottomCoord -= maxHeight, textureSprite, maxWidth, maxHeight, scaleHeight);
    }

    public static void drawTexturedRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int maxWidth, int maxHeight, float scaleHeight) {
        double v = textureSprite.m_118412_() - textureSprite.m_118411_();
        v *= (double)(1.0f - scaleHeight);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureSprite.m_247685_());
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)xCoord, (float)(yCoord + maxHeight), 0.0f).m_7421_(textureSprite.m_118409_(), textureSprite.m_118412_()).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(xCoord + maxWidth), (float)(yCoord + maxHeight), 0.0f).m_7421_(textureSprite.m_118410_(), textureSprite.m_118412_()).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(xCoord + maxWidth), (float)yCoord, 0.0f).m_7421_(textureSprite.m_118410_(), (float)((double)textureSprite.m_118411_() + v)).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)xCoord, (float)yCoord, 0.0f).m_7421_(textureSprite.m_118409_(), (float)((double)textureSprite.m_118411_() + v)).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void drawTexturedRect(float x, float y, float textureX, float textureY, float width, float height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y + height, 0.0f).m_7421_(textureX * 0.00390625f, (textureY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_((textureX + width) * 0.00390625f, (textureY + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y, 0.0f).m_7421_((textureX + width) * 0.00390625f, textureY * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(textureX * 0.00390625f, textureY * 0.00390625f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        GuiHelper.drawTexturedModalRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return pointX >= rectX && pointY >= rectY && pointX < rectX + rectWidth && pointY < rectY + rectHeight;
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(u * f, (v + (float)height) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_((u + (float)width) * f, (v + (float)height) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_((u + (float)width) * f, v * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(u * f, v * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(u * f, (v + (float)vHeight) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_((u + (float)uWidth) * f, (v + (float)vHeight) * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_((u + (float)uWidth) * f, v * f1).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(u * f, v * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, (float)left, (float)bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)right, (float)bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)right, (float)top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)left, (float)top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiHelper.drawGradientRect(currentStack, left, top, right, bottom, startColor, endColor);
    }

    public static void drawGradientRect(PoseStack stack, int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiHelper.drawGradientRect(stack.m_85850_().m_252922_(), 0, left, top, right, bottom, startColor, endColor);
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        bufferbuilder.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRectWithShadow(int x, int y, int xOffset, int yOffset, int xSize, int ySize, float color) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        GuiHelper.drawModalRectWithCustomSizedTexture(x, y, 0.0f, 0.0f, xSize, ySize, xSize, ySize);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)0.2f);
        GuiHelper.drawModalRectWithCustomSizedTexture(x + xOffset, y + yOffset, 0.0f, 0.0f, xSize, ySize, xSize, ySize);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawHoveringText(GuiGraphics graphics, Font font, List<String> textLines, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (String s : textLines) {
            components.add(Component.m_237113_((String)s));
        }
        graphics.m_280677_(font, components, Optional.empty(), mouseX, mouseY);
    }

    public static void renderTexturedRect(GuiGraphics graphics, ResourceLocation texture, int x, int y, int z, int u, int v, int width, int height, int texWidth, int texHeight) {
        graphics.m_280398_(texture, x, y, z, (float)u, (float)v, texWidth, texHeight, width, height);
    }

    public static void blit(GuiGraphics graphics, ResourceLocation tex, int x, int y, int sizeX, int sizeY, float p_282285_, float p_283199_, int p_282186_, int p_282322_, int p_282481_, int p_281887_) {
        graphics.m_280411_(tex, x, y, sizeX, sizeY, p_282285_, p_283199_, p_282186_, p_282322_, p_282481_, p_281887_);
    }

    public static void renderTransparentBackground(GuiGraphics graphics, Screen screen) {
        graphics.m_280024_(0, 0, screen.f_96543_, screen.f_96544_, -1072689136, -804253680);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite) {
        GuiHelper.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, 0);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        GuiHelper.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, textureWidth, textureHeight, zLevel, true);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, boolean blend) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blend) {
            RenderSystem.enableBlend();
        }
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = currentStack.m_85850_().m_252922_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            float uLocalMin = uMin + uLocalDif;
            float uLocalMax = uMax;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                float vLocalMin = vMin;
                float vLocalMax = vMax - vLocalDif;
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMin, vLocalMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMax, vLocalMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMax, vLocalMin).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMin, vLocalMin).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        if (blend) {
            RenderSystem.disableBlend();
        }
    }
}

