/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.sound;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JSGPositionedSound
extends AbstractTickableSoundInstance {
    protected double fullVolumeDistance = 32.0;
    protected double hearAbleDistance = 64.0;
    protected float maxVolume;

    protected JSGPositionedSound(BlockPos pos, SoundEvent soundEvent, SoundSource soundSource, RandomSource randomSource, boolean loop, float volume) {
        super(soundEvent, soundSource, randomSource);
        this.f_119575_ = pos.m_123341_();
        this.f_119576_ = pos.m_123342_();
        this.f_119577_ = pos.m_123343_();
        this.f_119578_ = loop;
        this.maxVolume = volume;
        this.f_119582_ = false;
    }

    public void stopPlaying() {
        JSGPositionedSound.getManager().m_120399_((SoundInstance)this);
    }

    public boolean isPlaying() {
        return Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this);
    }

    public void play() {
        try {
            if (!this.isPlaying()) {
                JSGPositionedSound.getManager().m_120367_((SoundInstance)this);
            }
        }
        catch (Exception e) {
            JSG.logger.error("", (Throwable)e);
        }
    }

    public Vec3 getPosition() {
        return new Vec3(this.f_119575_, this.f_119576_, this.f_119577_);
    }

    public double getDistanceFromSource() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 playerPos = player == null ? JSG.lastPlayerPosInWorld.m_252807_() : player.m_20182_();
        return this.getPosition().m_82554_(playerPos);
    }

    public float m_7769_() {
        double distanceFromSource = this.getDistanceFromSource();
        double fullDistance = this.fullVolumeDistance;
        double maxDistance = this.hearAbleDistance;
        if (fullDistance >= maxDistance) {
            maxDistance = fullDistance + 1.0;
        }
        float localVolume = distanceFromSource <= fullDistance ? this.getMaxVolume() : (distanceFromSource <= maxDistance ? (float)((double)this.getMaxVolume() * ((distanceFromSource - fullDistance) / (maxDistance - fullDistance))) : this.getMinVolume());
        return (float)((double)localVolume * (Double)JSGConfig.General.volume.get());
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public float getMinVolume() {
        return 0.0f;
    }

    public boolean m_7784_() {
        return true;
    }

    private static SoundManager getManager() {
        return Minecraft.m_91087_().m_91106_();
    }

    public void m_7788_() {
    }
}

