/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.sound;

import dev.tauri.jsg.registry.SoundRegistry;
import dev.tauri.jsg.sound.JSGPositionedSound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.registries.RegistryObject;

public enum SoundPositionedEnum {
    WORMHOLE_TRAVEL("misc.stargate.wormhole.travel", true, 1.0f),
    MILKYWAY_RING_ROLL("block.stargate.milkyway.ring_roll.loop", true, 1.0f),
    MILKYWAY_RING_ROLL_START("block.stargate.milkyway.ring_roll.start", false, 1.0f),
    UNIVERSE_RING_ROLL("block.stargate.universe.ring_roll.loop", true, 1.0f),
    UNIVERSE_RING_ROLL_START("block.stargate.universe.ring_roll.start", false, 1.0f),
    PEGASUS_RING_ROLL("block.stargate.pegasus.ring_roll.loop", true, 1.0f),
    PEGASUS_RING_ROLL_START("block.stargate.pegasus.ring_roll.start", false, 1.0f),
    WORMHOLE_LOOP("misc.stargate.wormhole.loop", true, 1.0f),
    MAINMENU_MUSIC("music.menu", false, 1.0f),
    MAINMENU_INTRO("music.menu.intro", false, 1.0f),
    KINO_FLYBY("misc.kino.flyby", true, 1.0f),
    PRINTER_PRINTING("misc.printer.printing", false, 1.0f);

    public final String id;
    public final ResourceLocation resourceLocation;
    public final boolean loop;
    public final float volume;
    public final RegistryObject<SoundEvent> event;

    private SoundPositionedEnum(String id, boolean loop, float volume) {
        this.id = id;
        this.resourceLocation = new ResourceLocation("jsg", id);
        this.loop = loop;
        this.volume = volume * 3.0f;
        this.event = SoundRegistry.REGISTER.register(id, () -> SoundEvent.m_262856_((ResourceLocation)this.resourceLocation, (float)64.0f));
    }

    public static void load() {
    }

    public JSGPositionedSound getInstance(BlockPos pos) {
        return new JSGPositionedSound(pos, (SoundEvent)this.event.get(), SoundSource.BLOCKS, SoundInstance.m_235150_(), this.loop, this.volume);
    }
}

