/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.ISpinHelper;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;

public class StargatePegasusSpinHelper
implements ISpinHelper {
    public SymbolTypeEnum<?> symbolType;
    public boolean isSpinning;
    public SymbolInterface currentSymbol;
    public EnumSpinDirection direction;
    private long spinStartTime;
    private SymbolInterface targetSymbol;
    private float startOffset;
    private float speedFactor;

    public StargatePegasusSpinHelper() {
    }

    @Override
    public boolean getIsSpinning() {
        return this.isSpinning;
    }

    @Override
    public void setIsSpinning(boolean value) {
        this.isSpinning = value;
    }

    @Override
    public SymbolInterface getCurrentSymbol() {
        return this.currentSymbol;
    }

    @Override
    public void setCurrentSymbol(SymbolInterface symbol) {
        this.currentSymbol = symbol;
    }

    @Override
    public SymbolInterface getTargetSymbol() {
        return this.targetSymbol;
    }

    public void setTargetSymbol(SymbolInterface symbol) {
        this.targetSymbol = symbol;
    }

    public StargatePegasusSpinHelper(SymbolTypeEnum<?> symbolType, SymbolInterface currentSymbol, EnumSpinDirection spinDirection, boolean isSpinning, SymbolInterface targetRingSymbol, long spinStartTime) {
        this.symbolType = symbolType;
        this.currentSymbol = currentSymbol;
        this.direction = spinDirection;
        this.isSpinning = isSpinning;
        this.targetSymbol = targetRingSymbol;
        this.spinStartTime = spinStartTime;
    }

    @Override
    public void initRotation(float speedFactor, long totalWorldTime, SymbolInterface targetSymbol, EnumSpinDirection direction, float startOffset, int plusRounds) {
        this.targetSymbol = targetSymbol;
        this.direction = direction;
        this.spinStartTime = totalWorldTime;
        this.startOffset = startOffset;
        this.speedFactor = speedFactor;
        this.isSpinning = true;
    }

    private float calculate(float tick) {
        if (tick < 0.0f) {
            return 0.0f;
        }
        return tick % 36.0f;
    }

    @Override
    public float apply(double tick) {
        float slot = this.calculate((float)(tick - (double)this.spinStartTime) * this.speedFactor);
        slot = (float)(((this.direction.mul == -1 ? Math.ceil(36.0f - slot) : Math.floor(slot)) + (double)this.startOffset) % 36.0);
        return slot;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(SymbolTypeEnum.getId(this.symbolType));
        buf.writeBoolean(this.isSpinning);
        buf.writeInt(this.currentSymbol.getId());
        buf.writeInt(this.direction.id);
        buf.writeLong(this.spinStartTime);
        buf.writeInt(this.targetSymbol.getId());
        buf.writeFloat(this.speedFactor);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.symbolType = SymbolTypeEnum.byId(buf.readInt());
        this.isSpinning = buf.readBoolean();
        this.currentSymbol = this.symbolType.valueOf(buf.readInt());
        this.direction = EnumSpinDirection.valueOf(buf.readInt());
        this.spinStartTime = buf.readLong();
        this.targetSymbol = this.symbolType.valueOf(buf.readInt());
        this.speedFactor = buf.readFloat();
        if (this.isSpinning) {
            this.initRotation(this.speedFactor, this.spinStartTime, this.targetSymbol, this.direction, 0.0f, 0);
        }
    }
}

