/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateMovieBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateTollanBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.config.ingame.BlockConfigOptionRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateTypeEnum {
    private static final Map<Integer, StargateTypeEnum> REGISTRY = new HashMap<Integer, StargateTypeEnum>();
    private static final Map<String, StargateTypeEnum> REGISTRY_STRING = new HashMap<String, StargateTypeEnum>();
    public static final StargateTypeEnum MILKYWAY = new StargateTypeEnum("MilkyWay", SymbolTypeRegistry.MILKYWAY, (Class<? extends BlockEntity>)StargateMilkyWayBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_MILKYWAY_BASE_BLOCK, (Supplier<Block>)BlockRegistry.DHD_MILKYWAY, BlockConfigOptionRegistry.GATE_MILKYWAY);
    public static final StargateTypeEnum PEGASUS = new StargateTypeEnum("Pegasus", SymbolTypeRegistry.PEGASUS, (Class<? extends BlockEntity>)StargatePegasusBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_PEGASUS_BASE_BLOCK, (Supplier<Block>)BlockRegistry.DHD_PEGASUS, BlockConfigOptionRegistry.GATE_PEGASUS);
    public static final StargateTypeEnum UNIVERSE = new StargateTypeEnum("Universe", SymbolTypeRegistry.UNIVERSE, (Class<? extends BlockEntity>)StargateUniverseBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_UNIVERSE_BASE_BLOCK, null, BlockConfigOptionRegistry.GATE_UNIVERSE);
    public static final StargateTypeEnum TOLLAN = new StargateTypeEnum("Tollan", SymbolTypeRegistry.MILKYWAY, (Class<? extends BlockEntity>)StargateTollanBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_TOLLAN_BASE_BLOCK, (Supplier<Block>)BlockRegistry.DHD_MILKYWAY, BlockConfigOptionRegistry.GATE_TOLLAN);
    public static final StargateTypeEnum ORLIN = new StargateTypeEnum("Orlin's", SymbolTypeRegistry.MILKYWAY, (Class<? extends BlockEntity>)StargateOrlinBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_ORLIN_BASE_BLOCK, null, BlockConfigOptionRegistry.GATE_COMMON);
    public static final StargateTypeEnum MOVIE = new StargateTypeEnum("Movie", SymbolTypeRegistry.MILKYWAY, (Class<? extends BlockEntity>)StargateMovieBaseBE.class, (Supplier<Block>)BlockRegistry.STARGATE_MOVIE_BASE_BLOCK, (Supplier<Block>)BlockRegistry.DHD_MILKYWAY, BlockConfigOptionRegistry.GATE_MILKYWAY);
    private static int nextId = 0;
    public final int id = nextId++;
    public final String name;
    public final SymbolTypeEnum<?> symbolType;
    public final Supplier<Block> baseBlockSupplier;
    @Nullable
    public final Supplier<Block> dhdBlockSupplier;
    public final Class<? extends BlockEntity> baseBlockEntityClass;
    public final ResourceLocation configType;

    public StargateTypeEnum(String name, SymbolTypeEnum<?> symbolType, Class<? extends BlockEntity> baseBlockEntityClass, Supplier<Block> baseBlockSupplier, @Nullable Supplier<Block> dhdBlockSupplier, @Nonnull ResourceLocation configType) {
        this.name = name;
        this.symbolType = symbolType;
        this.baseBlockEntityClass = baseBlockEntityClass;
        this.baseBlockSupplier = baseBlockSupplier;
        this.dhdBlockSupplier = dhdBlockSupplier;
        this.configType = configType;
        REGISTRY.put(this.id, this);
        REGISTRY_STRING.put(name.toLowerCase(), this);
    }

    public String toString() {
        return this.name;
    }

    public Block getBaseBlock() {
        return this.baseBlockSupplier.get();
    }

    public Block getDHDBlock() {
        if (this.dhdBlockSupplier == null) {
            return null;
        }
        return this.dhdBlockSupplier.get();
    }

    public static StargateTypeEnum valueOf(int id) {
        return REGISTRY.get(id);
    }

    public static StargateTypeEnum valueOf(String id) {
        return REGISTRY_STRING.get(id.toLowerCase());
    }

    public static Collection<StargateTypeEnum> values() {
        return REGISTRY.values();
    }

    @Nullable
    public static StargateTypeEnum getRandom(RandomSource random) {
        if (REGISTRY.isEmpty()) {
            return null;
        }
        return new ArrayList<StargateTypeEnum>(REGISTRY.values()).get(random.m_188503_(REGISTRY.values().size()));
    }

    @Nullable
    public static StargateTypeEnum getRandomClassic(RandomSource random) {
        for (int i = 0; i < 100; ++i) {
            StargateTypeEnum r = StargateTypeEnum.getRandom(random);
            if (r != null) continue;
            return null;
        }
        return null;
    }

    public static StargateTypeEnum parse(SymbolTypeEnum<?> type) {
        if (type == SymbolTypeRegistry.MILKYWAY) {
            return MILKYWAY;
        }
        if (type == SymbolTypeRegistry.PEGASUS) {
            return PEGASUS;
        }
        if (type == SymbolTypeRegistry.UNIVERSE) {
            return UNIVERSE;
        }
        return MILKYWAY;
    }
}

