/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.codesender;

import dev.tauri.jsg.stargate.codesender.CodeSender;
import dev.tauri.jsg.stargate.codesender.ComputerCodeSender;
import dev.tauri.jsg.stargate.codesender.PlayerCodeSender;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public enum CodeSenderType {
    PLAYER(0, PlayerCodeSender::new),
    COMPUTER(1, ComputerCodeSender::new);

    private static final Map<Integer, CodeSenderType> idMap;
    public final Supplier<CodeSender> constructor;
    public final int id;

    private CodeSenderType(int id, Supplier<CodeSender> constructor) {
        this.constructor = constructor;
        this.id = id;
    }

    public static CodeSenderType fromId(int id) {
        return idMap.get(id);
    }

    static {
        idMap = new HashMap<Integer, CodeSenderType>();
        for (CodeSenderType member : CodeSenderType.values()) {
            idMap.put(member.id, member);
        }
    }
}

